"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicesContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_time_range = require("../../../../hooks/use_time_range");
var _http_api = require("../../../../../common/http_api");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _section = require("../../components/section");
var _section_titles = require("./section_titles");
var _constants = require("../../../../../common/constants");
var _links = require("../../links");
var _constants2 = require("../../constants");
var _link_to_apm_service = require("../../links/link_to_apm_service");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_request_observable = require("../../hooks/use_request_observable");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _use_metadata_state = require("../../hooks/use_metadata_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/services.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ServicesContent = ({
  hostName,
  dateRange
}) => {
  const {
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    isActiveTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    metadata,
    loading: metadataLoading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const linkProps = (0, _public.useLinkProps)({
    app: 'home',
    hash: '/tutorial/apm'
  });
  const serverlessLinkProps = (0, _public.useLinkProps)({
    app: 'apm',
    pathname: '/onboarding'
  });
  const parsedDateRange = (0, _use_time_range.useTimeRange)({
    rangeFrom: dateRange.from,
    rangeTo: dateRange.to
  });
  const params = (0, _react.useMemo)(() => ({
    filters: {
      [_constants.HOST_NAME_FIELD]: hostName
    },
    ...parsedDateRange
  }), [hostName, parsedDateRange]);
  const query = (0, _react.useMemo)(() => ({
    ...params,
    filters: JSON.stringify(params.filters)
  }), [params]);
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/infra/services', {
      method: 'GET',
      query
    });
    return (0, _ioTsUtils.decodeOrThrow)(_http_api.ServicesAPIResponseRT)(response);
  }, [query], {
    requestObservable$: request$,
    autoFetch: isActiveTab('overview')
  });
  const services = data === null || data === void 0 ? void 0 : data.services;
  const hasServices = services === null || services === void 0 ? void 0 : services.length;
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_titles.ServicesSectionTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 14
      }
    }),
    collapsible: true,
    "data-test-subj": "infraAssetDetailsServicesCollapsible",
    id: "services",
    extraAction: /*#__PURE__*/_react.default.createElement(_links.LinkToApmServices, {
      entityId: hostName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 20
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.infra.assetDetails.services.getServicesRequestErrorTitle', {
      defaultMessage: 'Error'
    }),
    color: "danger",
    iconType: "alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.infra.assetDetails.services.getServicesRequestError', {
    defaultMessage: 'An error occurred while fetching services.'
  })) : (0, _use_fetcher.isPending)(status) || metadataLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }) : hasServices ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    "data-test-subj": "infraAssetDetailsServicesContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, services.map((service, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_link_to_apm_service.LinkToApmService, {
    serviceName: service.serviceName,
    agentName: service.agentName,
    dateRange: dateRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  })))) : metadata !== null && metadata !== void 0 && metadata.hasSystemIntegration ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.services.noServicesMsg",
    defaultMessage: "We were unable to find services running on this host. Click {apmTutorialLink} to instrument your services with APM.",
    values: {
      apmTutorialLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "aria-label": _i18n.i18n.translate('xpack.infra.servicesContent.euiLink.apmTutorialLinkLabel', {
          defaultMessage: 'APM Instrumentation Tutorial'
        }),
        "data-test-subj": "assetDetailsTooltipAPMTutorialLink",
        href: isServerlessEnv ? serverlessLinkProps.href : linkProps.href,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.table.services.noServices.tutorialLink",
        defaultMessage: "here",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "assetDetailsAPMTroubleshootingLink",
    href: _constants2.APM_HOST_TROUBLESHOOTING_LINK,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.table.services.noServices.troubleshootingLink",
    defaultMessage: "Troubleshooting",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.services.noServicesWithApmMessage",
    defaultMessage: "No services found on this host.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "assetDetailsAPMHostTroubleshootingLink",
    href: _constants2.APM_HOST_TROUBLESHOOTING_LINK,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.table.services.noServices.troubleshootingLink",
    defaultMessage: "Troubleshooting",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }))));
};
exports.ServicesContent = ServicesContent;