"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DockerCharts = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_container_metrics_charts = require("../hooks/use_container_metrics_charts");
var _section = require("../components/section");
var _charts_grid = require("../charts_grid/charts_grid");
var _chart = require("./chart");
var _section_title = require("../components/section_title");
var _translations = require("../translations");
var _constants = require("../../../common/visualizations/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/charts/docker_charts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FRAGMENT_BASE = 'key-metrics';
const DockerCharts = exports.DockerCharts = /*#__PURE__*/_react.default.forwardRef(({
  entityId,
  dataView,
  dateRange,
  metric,
  onShowAll
}, ref) => {
  const {
    charts
  } = (0, _use_container_metrics_charts.useDockerContainerPageViewMetricsCharts)({
    metric,
    metricsDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
  });
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
      title: _translations.CONTAINER_METRIC_GROUP_TITLES[metric],
      tooltipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.charts.container.toolTip",
        defaultMessage: "See container-related {link} for more information",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "infraAssetDetailsViewContainerMetricsDocumentationLink",
            href: `${_constants.CONTAINER_METRICS_DOC_HREF}#${FRAGMENT_BASE}-${metric}`,
            target: "_blank",
            className: (0, _css.cx)({
              [(0, _css.css)`
                            text-transform: lowercase;
                          `]: metric !== 'cpu'
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 47,
              columnNumber: 23
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.infra.assetDetails.charts.container.toolTip.linkText",
            defaultMessage: "{metric} metrics",
            values: {
              metric: _translations.CONTAINER_METRIC_GROUP_TITLES[metric]
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 57,
              columnNumber: 25
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 17
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }),
    "data-test-subj": `infraAssetDetailsDockerChartsSection${metric}`,
    id: metric,
    ref: ref,
    extraAction: onShowAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.charts.host.showAllButton.ariaLabel', {
        defaultMessage: 'Show all {metric} charts',
        values: {
          metric: _translations.CONTAINER_METRIC_GROUP_TITLES[metric]
        }
      }),
      "data-test-subj": "infraAssetDetailsHostChartsShowAllButton",
      onClick: () => onShowAll(metric),
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.charts.host.showAllButton",
      defaultMessage: "Show all",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 15
      }
    })) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    columns: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, charts.map(chart => /*#__PURE__*/_react.default.createElement(_chart.Chart, {
    id: chart.id,
    key: chart.id,
    lensAttributes: chart,
    entityId: entityId,
    dateRange: dateRange,
    dataView: dataView,
    queryField: (0, _common.findInventoryFields)('container').id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }))));
});