"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/logs-shared-plugin/common");
var _link_to_logs = require("../pages/link_to/link_to_logs");
var _logs = require("../pages/logs");
var _common_providers = require("./common_providers");
var _common_styles = require("./common_styles");
var _kbn_url_state_context = require("../containers/kbn_url_state_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/apps/logs_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const renderApp = (core, plugins, pluginStart, isLogsExplorerAccessible, {
  element,
  history,
  setHeaderActionMenu,
  theme$
}) => {
  const storage = new _public.Storage(window.localStorage);
  (0, _common_styles.prepareMountElement)(element, 'infraLogsPage');
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(LogsApp, {
    core: core,
    storage: storage,
    history: history,
    plugins: plugins,
    pluginStart: pluginStart,
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$,
    isLogsExplorerAccessible: isLogsExplorerAccessible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
const LogsApp = ({
  core,
  history,
  pluginStart,
  plugins,
  setHeaderActionMenu,
  storage,
  theme$,
  isLogsExplorerAccessible
}) => {
  const {
    logs
  } = core.application.capabilities;
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
    core: core,
    pluginStart: pluginStart,
    plugins: plugins,
    theme$: theme$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_common_providers.CommonInfraProviders, {
    appName: "Logs UI",
    setHeaderActionMenu: setHeaderActionMenu,
    storage: storage,
    theme$: theme$,
    triggersActionsUI: plugins.triggersActionsUi,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_kbn_url_state_context.KbnUrlStateStorageFromRouterProvider, {
    history: history,
    toastsService: core.notifications.toasts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, isLogsExplorerAccessible && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    exact: true,
    render: () => {
      var _plugins$share$url$lo;
      (_plugins$share$url$lo = plugins.share.url.locators.get(_common.LOGS_LOCATOR_ID)) === null || _plugins$share$url$lo === void 0 ? void 0 : _plugins$share$url$lo.navigate({});
      return null;
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/link-to",
    component: _link_to_logs.LinkToLogsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }), (logs === null || logs === void 0 ? void 0 : logs.show) && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    component: _logs.LogsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 30
    }
  }))))));
};