"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleFormat = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alert_link = require("../../../common/alerting/metrics/alert_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleFormat = ({
  assetDetailsLocator,
  inventoryLocator
}) => {
  return ({
    fields
  }) => {
    var _fields$ALERT_REASON;
    const reason = (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '-';
    return {
      reason,
      link: (0, _alert_link.getInventoryViewInAppUrl)({
        fields,
        assetDetailsLocator,
        inventoryLocator
      }),
      hasBasePath: true
    };
  };
};
exports.getRuleFormat = getRuleFormat;