"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _use_timeline_chart_theme = require("../../../hooks/use_timeline_chart_theme");
var _color_palette = require("../../../../common/color_palette");
var _use_snaphot = require("../../../pages/metrics/inventory_view/hooks/use_snaphot");
var _create_inventory_metric_formatter = require("../../../pages/metrics/inventory_view/lib/create_inventory_metric_formatter");
var _calculate_domain = require("../../../pages/metrics/metrics_explorer/components/helpers/calculate_domain");
var _get_metric_id = require("../../../pages/metrics/metrics_explorer/components/helpers/get_metric_id");
var _series_chart = require("../../../pages/metrics/metrics_explorer/components/series_chart");
var _use_metrics_explorer_options = require("../../../pages/metrics/metrics_explorer/hooks/use_metrics_explorer_options");
var _criterion_preview_chart = require("../../common/criterion_preview_chart/criterion_preview_chart");
var _threshold_annotations = require("../../common/criterion_preview_chart/threshold_annotations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/inventory/components/expression_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExpressionChart = ({
  expression,
  kuery,
  nodeType,
  sourceId,
  accountId = '',
  region = '',
  schema
}) => {
  var _expression$warningTh, _expression$warningTh2, _nodes$2, _nodes$2$metrics$, _nodes$3;
  const chartTheme = (0, _use_timeline_chart_theme.useTimelineChartTheme)();
  const timerange = (0, _react.useMemo)(() => ({
    interval: `${expression.timeSize || 1}${expression.timeUnit}`,
    from: (0, _moment.default)().subtract((expression.timeSize || 1) * 20, expression.timeUnit).valueOf(),
    to: (0, _moment.default)().valueOf(),
    forceInterval: true
  }), [expression.timeSize, expression.timeUnit]);
  const buildCustomMetric = metric => ({
    ...metric,
    type: 'custom'
  });
  const {
    loading,
    nodes
  } = (0, _use_snaphot.useSnapshot)({
    kuery,
    metrics: expression.metric === 'custom' ? [buildCustomMetric(expression.customMetric)] : [{
      type: expression.metric
    }],
    groupBy: [],
    nodeType,
    sourceId,
    currentTime: 0,
    accountId,
    region,
    timerange,
    schema
  });
  const metric = {
    field: expression.metric,
    aggregation: 'avg',
    color: _color_palette.Color.color0
  };
  const dateFormatter = (0, _react.useMemo)(() => {
    var _nodes$, _nodes$$metrics$, _first, _last;
    const firstSeries = (_nodes$ = nodes[0]) === null || _nodes$ === void 0 ? void 0 : (_nodes$$metrics$ = _nodes$.metrics[0]) === null || _nodes$$metrics$ === void 0 ? void 0 : _nodes$$metrics$.timeseries;
    const firstTimestamp = (_first = (0, _lodash.first)(firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.rows)) === null || _first === void 0 ? void 0 : _first.timestamp;
    const lastTimestamp = (_last = (0, _lodash.last)(firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.rows)) === null || _last === void 0 ? void 0 : _last.timestamp;
    if (firstTimestamp == null || lastTimestamp == null) {
      return value => `${value}`;
    }
    return (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  }, [nodes]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const yAxisFormater = (0, _react.useCallback)((0, _create_inventory_metric_formatter.createInventoryMetricFormatter)(expression.metric === 'custom' ? buildCustomMetric(expression.customMetric) : {
    type: expression.metric
  }), [expression.metric]);
  if (loading || !nodes) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.LoadingState, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 12
      }
    });
  }
  const convertThreshold = threshold => convertMetricValue(expression.metric, threshold);
  const convertedThresholds = expression.threshold.map(convertThreshold);
  const convertedWarningThresholds = (_expression$warningTh = (_expression$warningTh2 = expression.warningThreshold) === null || _expression$warningTh2 === void 0 ? void 0 : _expression$warningTh2.map(convertThreshold)) !== null && _expression$warningTh !== void 0 ? _expression$warningTh : [];
  const criticalThresholds = convertedThresholds.slice().sort();
  const warningThresholds = convertedWarningThresholds.slice().sort();
  const thresholds = [...criticalThresholds, ...warningThresholds].sort();

  // Creating a custom series where the ID is changed to 0
  // so that we can get a proper domian
  const firstSeries = (_nodes$2 = nodes[0]) === null || _nodes$2 === void 0 ? void 0 : (_nodes$2$metrics$ = _nodes$2.metrics[0]) === null || _nodes$2$metrics$ === void 0 ? void 0 : _nodes$2$metrics$.timeseries;
  if (!firstSeries || !firstSeries.rows || firstSeries.rows.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.NoDataState, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 12
      }
    });
  }
  const series = {
    ...firstSeries,
    id: (_nodes$3 = nodes[0]) === null || _nodes$3 === void 0 ? void 0 : _nodes$3.name,
    rows: firstSeries.rows.map(row => {
      const newRow = {
        ...row
      };
      thresholds.forEach((thresholdValue, index) => {
        newRow[(0, _get_metric_id.getMetricId)(metric, `threshold_${index}`)] = thresholdValue;
      });
      return newRow;
    })
  };
  const firstTimestamp = (0, _lodash.first)(firstSeries.rows).timestamp;
  const lastTimestamp = (0, _lodash.last)(firstSeries.rows).timestamp;
  const dataDomain = (0, _calculate_domain.calculateDomain)(series, [metric], false);
  const domain = {
    max: Math.max(dataDomain.max, (0, _lodash.last)(thresholds) || dataDomain.max) * 1.1,
    // add 10% headroom.
    min: Math.min(dataDomain.min, (0, _lodash.first)(thresholds) || dataDomain.min) * 0.9 // add 10% floor
  };
  if (domain.min === (0, _lodash.first)(convertedThresholds)) {
    domain.min = domain.min * 0.9;
  }
  const {
    timeSize,
    timeUnit
  } = expression;
  const timeLabel = _criterion_preview_chart.TIME_LABELS[timeUnit];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.ChartContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: _use_metrics_explorer_options.MetricsExplorerChartType.bar,
    metric: metric,
    id: "0",
    series: series,
    stack: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_threshold_annotations.ThresholdAnnotations, {
    comparator: (0, _common.convertToBuiltInComparators)(expression.comparator),
    threshold: convertedThresholds,
    sortedThresholds: criticalThresholds,
    color: _color_palette.Color.color1,
    id: "critical",
    firstTimestamp: firstTimestamp,
    lastTimestamp: lastTimestamp,
    domain: domain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }), expression.warningComparator && expression.warningThreshold && /*#__PURE__*/_react.default.createElement(_threshold_annotations.ThresholdAnnotations, {
    comparator: (0, _common.convertToBuiltInComparators)(expression.warningComparator),
    threshold: convertedWarningThresholds,
    sortedThresholds: warningThresholds,
    color: _color_palette.Color.color5,
    id: "warning",
    firstTimestamp: firstTimestamp,
    lastTimestamp: lastTimestamp,
    domain: domain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: yAxisFormater,
    domain: domain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartTheme.baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, (0, _extends2.default)({}, _criterion_preview_chart.tooltipProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, series.id !== 'ALL' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alerts.dataTimeRangeLabelWithGrouping",
    defaultMessage: "Last {lookback} {timeLabel} of data for {id}",
    values: {
      id: series.id,
      timeLabel,
      lookback: timeSize * 20
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alerts.dataTimeRangeLabel",
    defaultMessage: "Last {lookback} {timeLabel}",
    values: {
      timeLabel,
      lookback: timeSize * 20
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  }))));
};
exports.ExpressionChart = ExpressionChart;
const convertMetricValue = (metric, value) => {
  if (converters[metric]) {
    return converters[metric](value);
  } else {
    return value;
  }
};
const converters = {
  cpu: n => Number(n) / 100,
  cpuV2: n => Number(n) / 100,
  memory: n => Number(n) / 100,
  tx: n => Number(n) / 8,
  rx: n => Number(n) / 8,
  rxV2: n => Number(n) / 8,
  txV2: n => Number(n) / 8
};