"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REASON_TOOL = exports.PLANNING_TOOLS = exports.NEXT_TOOL = exports.COMPLETE_TOOL = void 0;
exports.isPlanningToolName = isPlanningToolName;
exports.removeSystemToolCalls = removeSystemToolCalls;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REASON_TOOL = exports.REASON_TOOL = {
  description: 'reason or reflect about the task ahead or the results',
  schema: {
    type: 'object',
    properties: {}
  }
};
const NEXT_TOOL = exports.NEXT_TOOL = {
  description: 'perform the next step in the process',
  schema: {
    type: 'object',
    properties: {}
  }
};
const COMPLETE_TOOL = exports.COMPLETE_TOOL = {
  description: 'complete the task based on the last output',
  schema: {
    type: 'object',
    properties: {}
  }
};
const PLANNING_TOOLS = exports.PLANNING_TOOLS = {
  reason: REASON_TOOL,
  complete: COMPLETE_TOOL
};

// eslint-disable-next-line @typescript-eslint/consistent-type-definitions

// eslint-disable-next-line @typescript-eslint/consistent-type-definitions

function isPlanningToolName(name) {
  return name === 'reason' || name === 'complete';
}
function removeSystemToolCalls(messages, to = messages.length) {
  return messages.slice(0, to).filter(message => {
    var _message$toolCalls;
    const isInternalMessage = message.role === _inferenceCommon.MessageRole.Tool && isPlanningToolName(message.name) || message.role === _inferenceCommon.MessageRole.Assistant && ((_message$toolCalls = message.toolCalls) === null || _message$toolCalls === void 0 ? void 0 : _message$toolCalls.some(toolCall => isPlanningToolName(toolCall.function.name)));
    return !isInternalMessage;
  }).concat(messages.slice(to));
}