"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleLifecycleCallbacks = handleLifecycleCallbacks;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function handleLifecycleCallbacks({
  callbackManager
}) {
  return source$ => {
    let tokenCount;
    return new _rxjs.Observable(subscriber => {
      return source$.subscribe({
        next: value => {
          if ((0, _inferenceCommon.isChatCompletionTokenCountEvent)(value)) {
            tokenCount = value.tokens;
          }
          subscriber.next(value);
        },
        error: err => {
          callbackManager.onError({
            error: err
          });
          subscriber.error(err);
        },
        complete: () => {
          callbackManager.onComplete({
            tokens: tokenCount
          });
          subscriber.complete();
        }
      });
    });
  };
}