"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.homeSections = exports.IndexManagementHome = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _documentation = require("../../services/documentation");
var _component_templates = require("../../components/component_templates");
var _app_context = require("../../app_context");
var _index_list = require("./index_list");
var _enrich_policies_list = require("./enrich_policies_list");
var _details_page = require("./index_list/details_page");
var _data_stream_list = require("./data_stream_list");
var _template_list = require("./template_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/home.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const homeSections = exports.homeSections = [_constants.Section.Indices, _constants.Section.DataStreams, _constants.Section.IndexTemplates, _constants.Section.ComponentTemplates, _constants.Section.EnrichPolicies];
const IndexManagementHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const {
    plugins: {
      console: consolePlugin
    },
    privs
  } = (0, _app_context.useAppContext)();
  const tabs = [{
    id: _constants.Section.Indices,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.indicesTabTitle",
      defaultMessage: "Indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    })
  }, {
    id: _constants.Section.DataStreams,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.dataStreamsTabTitle",
      defaultMessage: "Data Streams",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    })
  }, {
    id: _constants.Section.IndexTemplates,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.indexTemplatesTabTitle",
      defaultMessage: "Index Templates",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    })
  }];
  if (privs.manageIndexTemplates) {
    tabs.push({
      id: _constants.Section.ComponentTemplates,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.componentTemplatesTabTitle",
        defaultMessage: "Component Templates",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      })
    });
  }
  if (privs.monitorEnrich) {
    tabs.push({
      id: _constants.Section.EnrichPolicies,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.enrichPoliciesTabTitle",
        defaultMessage: "Enrich Policies",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 9
        }
      })
    });
  }
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };
  const indexManagementTabs = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "indexManagementHeaderContent",
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.appTitle",
      defaultMessage: "Index Management",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    })),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: _documentation.documentationService.getIdxMgmtDocumentationLink(),
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.idxMgmtDocsLinkText",
      defaultMessage: "Index Management docs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 13
      }
    }))],
    tabs: tabs.map(tab => ({
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': `${tab.id}Tab`,
      label: tab.name
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${_constants.Section.DataStreams}`, `/${_constants.Section.DataStreams}/:dataStreamName?`],
    component: _data_stream_list.DataStreamList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/${_constants.Section.Indices}`,
    component: _index_list.IndexList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${_constants.Section.IndexTemplates}`, `/${_constants.Section.IndexTemplates}/:templateName?`],
    component: _template_list.TemplateList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), privs.manageIndexTemplates && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${_constants.Section.ComponentTemplates}`, `/${_constants.Section.ComponentTemplates}/:componentTemplateName?`],
    component: _component_templates.ComponentTemplateList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }), privs.monitorEnrich && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/${_constants.Section.EnrichPolicies}`,
    component: _enrich_policies_list.EnrichPoliciesList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  })), consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 43
    }
  }) : null);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/${_constants.Section.Indices}/index_details`,
    component: _details_page.IndexDetailsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => indexManagementTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }));
};
exports.IndexManagementHome = IndexManagementHome;