"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentFieldsTreeEditor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _mappings_state_context = require("../../mappings_state_context");
var _fields = require("./fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields_tree_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DocumentFieldsTreeEditor = ({
  onCancelAddingNewFields,
  isAddingFields,
  semanticTextInfo,
  pendingFieldsRef
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    fields: {
      byId,
      rootLevelFields
    },
    documentFields: {
      status,
      fieldToAddFieldTo
    }
  } = (0, _mappings_state_context.useMappingsState)();
  const createFieldFormRef = (0, _react.useRef)(null);
  const getField = (0, _react.useCallback)(fieldId => byId[fieldId], [byId]);
  const fields = (0, _react.useMemo)(() => rootLevelFields.map(getField), [rootLevelFields, getField]);
  const addField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.createField'
    });
  }, [dispatch]);
  const renderCreateField = () => {
    // The "fieldToAddFieldTo" is undefined when adding to the top level "properties" object.
    const isCreateFieldFormVisible = status === 'creatingField' && fieldToAddFieldTo === undefined;
    if (!isCreateFieldFormVisible) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_fields.CreateField, {
      isCancelable: fields.length > 0,
      allFields: byId,
      isRootLevelField: true,
      onCancelAddingNewFields: onCancelAddingNewFields,
      isAddingFields: isAddingFields,
      semanticTextInfo: semanticTextInfo,
      createFieldFormRef: createFieldFormRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    });
  };
  const renderAddFieldButton = () => {
    const isDisabled = status !== 'idle';
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      disabled: isDisabled,
      onClick: addField,
      iconType: "plusInCircleFilled",
      "data-test-subj": "addFieldButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.addFieldButtonLabel', {
      defaultMessage: 'Add field'
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_fields.FieldsList, {
    fields: fields,
    state: (0, _mappings_state_context.useMappingsState)(),
    isAddingFields: isAddingFields,
    pendingFieldsRef: pendingFieldsRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), renderCreateField(), renderAddFieldButton());
};
exports.DocumentFieldsTreeEditor = DocumentFieldsTreeEditor;