"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocaleParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _edit_field = require("../fields/edit_field");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _documentation = require("../../../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/locale_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LocaleParameter = ({
  defaultToggleValue
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.date.localeFieldTitle', {
    defaultMessage: 'Set locale'
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.dateType.localeFieldDescription",
    defaultMessage: "The locale to use when parsing dates. This is useful because months might not have the same name or abbreviation in all languages. Defaults to the {root} locale.",
    values: {
      root: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getRootLocaleLink(),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 13
        }
      }, "ROOT")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }),
  defaultToggleValue: defaultToggleValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "locale",
  config: (0, _lib.getFieldConfig)('locale'),
  component: _shared_imports.Field,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 5
  }
}));
exports.LocaleParameter = LocaleParameter;