"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyIndexTemplatesDeprecation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _documentation = require("../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/index_templates/legacy_index_template_deprecation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LegacyIndexTemplatesDeprecation = ({
  history,
  showCta
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.legacyIndexTemplatesDeprecation.title', {
      defaultMessage: 'Legacy index templates are deprecated in favor of composable index templates'
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "legacyIndexTemplateDeprecationWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, showCta && history && /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.legacyIndexTemplatesDeprecation.description",
    defaultMessage: "{createTemplateButton} or {learnMoreLink}",
    values: {
      createTemplateButton: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "createTemplateButton"
      }, (0, _shared_imports.reactRouterNavigate)(history, '/create_template'), {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.legacyIndexTemplatesDeprecation.createTemplatesButtonLabel",
        defaultMessage: "Create composable template",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 19
        }
      })),
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getTemplatesDocumentationLink(),
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.home.legacyIndexTemplatesDeprecation.ctaLearnMoreLinkText', {
        defaultMessage: 'learn more.'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  })), !showCta && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _documentation.documentationService.getTemplatesDocumentationLink(),
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.home.legacyIndexTemplatesDeprecation.learnMoreLinkText', {
    defaultMessage: 'Learn more.'
  })));
};
exports.LegacyIndexTemplatesDeprecation = LegacyIndexTemplatesDeprecation;