"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateTabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_details/tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TABS = [{
  id: 'summary',
  name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.summaryTabTitle', {
    defaultMessage: 'Summary'
  })
}, {
  id: 'settings',
  name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.settingsTabTitle', {
    defaultMessage: 'Settings'
  })
}, {
  id: 'mappings',
  name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.mappingsTabTitle', {
    defaultMessage: 'Mappings'
  })
}, {
  id: 'aliases',
  name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.aliasesTabTitle', {
    defaultMessage: 'Aliases'
  })
}];
const ComponentTemplateTabs = ({
  setActiveTab,
  activeTab
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, TABS.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => {
      setActiveTab(tab.id);
    },
    isSelected: tab.id === activeTab,
    key: tab.id,
    "data-test-subj": `${tab.id}Tab`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, tab.name)));
};
exports.ComponentTemplateTabs = ComponentTemplateTabs;