"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPriorityField = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _edit_policy_context = require("../../../edit_policy_context");
var _form = require("../../../form");
var _ = require("../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/index_priority_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexPriorityField = ({
  phase
}) => {
  const {
    policy,
    isNewPolicy
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const initialToggleValue = (0, _react.useMemo)(() => {
    var _policy$phases$phase, _policy$phases$phase2, _policy$phases$phase3;
    return (
      // enable index priority for new policies
      isNewPolicy ||
      // enable index priority for new phases:
      !((_policy$phases$phase = policy.phases[phase]) !== null && _policy$phases$phase !== void 0 && _policy$phases$phase.actions) ||
      // enable index priority if it's set:
      ((_policy$phases$phase2 = policy.phases[phase]) === null || _policy$phases$phase2 === void 0 ? void 0 : (_policy$phases$phase3 = _policy$phases$phase2.actions) === null || _policy$phases$phase3 === void 0 ? void 0 : _policy$phases$phase3.set_priority) != null
    );
  }, [isNewPolicy, policy.phases, phase]);
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_.DescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.indexPriorityText",
      defaultMessage: "Index priority",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.warmPhase.indexPriorityExplanationText",
      defaultMessage: "Set the priority for recovering your indices after a node restart. Indices with higher priorities are recovered before indices with lower priorities.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
      docPath: docLinks.links.elasticsearch.ilmSetPriority,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    })),
    titleSize: "xs",
    fullWidth: true,
    switchProps: {
      label: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.indexPriority.indexPriorityEnabledFieldLabel', {
        defaultMessage: 'Set index priority'
      }),
      'data-test-subj': `${phase}-indexPrioritySwitch`,
      initialValue: initialToggleValue
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `phases.${phase}.actions.set_priority.priority`,
    component: _shared_imports.NumericField,
    euiFieldProps: {
      fullWidth: false,
      'data-test-subj': `${phase}-indexPriority`,
      min: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
};
exports.IndexPriorityField = IndexPriorityField;