"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._runBackportPackagePolicyInputId = _runBackportPackagePolicyInputId;
exports.runBackportPackagePolicyInputId = runBackportPackagePolicyInputId;
var _services = require("../../services");
var _packages = require("../../services/epm/packages");
var _get_input_with_ids = require("../../services/package_policies/get_input_with_ids");
var _package_policy = require("../../services/package_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runBackportPackagePolicyInputId(params) {
  const esClient = _services.appContextService.getInternalUserESClient();
  const savedObjectsClient = _services.appContextService.getInternalUserSOClient();
  return _runBackportPackagePolicyInputId(savedObjectsClient, esClient, params.logger, params.abortController);
}
async function _runBackportPackagePolicyInputId(soClient, esClient, logger, abortController) {
  for await (const items of await _services.packagePolicyService.fetchAllItems(soClient)) {
    if (abortController !== null && abortController !== void 0 && abortController.signal.aborted) {
      throw new Error('Task was aborted');
    }
    const packagePolicyToUpdate = items.reduce((acc, packagePolicy) => {
      if (packagePolicy.inputs.some(input => !input.id)) {
        acc.push(packagePolicy);
      }
      return acc;
    }, []);
    if (packagePolicyToUpdate.length === 0) {
      continue;
    }
    const updates = [];
    for (const packagePolicy of packagePolicyToUpdate) {
      if (abortController !== null && abortController !== void 0 && abortController.signal.aborted) {
        throw new Error('Task was aborted');
      }
      if (!packagePolicy.package) {
        continue;
      }
      try {
        const pkgInfo = await (0, _packages.getPackageInfo)({
          savedObjectsClient: soClient,
          pkgName: packagePolicy.package.name,
          pkgVersion: packagePolicy.package.version,
          ignoreUnverified: true,
          prerelease: true
        });
        const inputs = (0, _get_input_with_ids.getInputsWithIds)(packagePolicy, packagePolicy.id, undefined, pkgInfo);
        updates.push({
          id: packagePolicy.id,
          inputs
        });
      } catch (error) {
        logger.error(`Failed to backport package policy ${packagePolicy.id}: ${error.message}`, {
          error
        });
      }
    }
    const soType = await (0, _package_policy.getPackagePolicySavedObjectType)();
    await soClient.bulkUpdate(updates.map(update => ({
      type: soType,
      id: update.id,
      attributes: {
        inputs: update.inputs
      }
    })));
  }
}