"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.TYPE = exports.FleetPolicyRevisionsCleanupTask = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _task = require("@kbn/task-manager-plugin/server/task");
var _elasticsearch = require("@elastic/elasticsearch");
var _services = require("../../services");
var _cleanup_policy_revisions = require("./cleanup_policy_revisions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TYPE = exports.TYPE = 'fleet:policy-revisions-cleanup-task';
const VERSION = exports.VERSION = '1.0.0';
const TITLE = 'Fleet Policy Revisions Cleanup Task';
const SCOPE = ['fleet'];
const TASK_TIMEOUT = '5m';
class FleetPolicyRevisionsCleanupTask {
  constructor(setupContract) {
    var _config$interval, _config$maxRevisions, _config$maxPoliciesPe;
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "wasStarted", false);
    (0, _defineProperty2.default)(this, "taskInterval", void 0);
    (0, _defineProperty2.default)(this, "maxRevisions", void 0);
    (0, _defineProperty2.default)(this, "maxPoliciesPerRun", void 0);
    (0, _defineProperty2.default)(this, "start", async ({
      taskManager
    }) => {
      if (!taskManager) {
        this.logger.error('[FleetPolicyRevisionsCleanupTask] Missing required service during start');
        return;
      }
      this.wasStarted = true;
      this.logger.info(`[FleetPolicyRevisionsCleanupTask] Started with interval of [${this.taskInterval}], max_revisions: ${this.maxRevisions}, max_policies_per_run: ${this.maxPoliciesPerRun}`);
      try {
        await taskManager.ensureScheduled({
          id: this.taskId,
          taskType: TYPE,
          scope: SCOPE,
          schedule: {
            interval: this.taskInterval
          },
          state: {},
          params: {
            version: VERSION
          }
        });
      } catch (e) {
        this.logger.error(`Error scheduling task FleetPolicyRevisionsCleanupTask, error: ${e.message}`, e);
      }
    });
    (0, _defineProperty2.default)(this, "runTask", async (taskInstance, core, abortController) => {
      // Check if the feature flag is enabled
      if (!_services.appContextService.getExperimentalFeatures().enableFleetPolicyRevisionsCleanupTask) {
        this.logger.debug('[FleetPolicyRevisionsCleanupTask] Aborting runTask: fleet policy revision cleanup task feature is disabled');
        return;
      }
      if (!this.wasStarted) {
        this.logger.debug('[FleetPolicyRevisionsCleanupTask] runTask Aborted. Task not started yet');
        return;
      }

      // Check that this task is current
      if (taskInstance.id !== this.taskId) {
        this.logger.debug(`[FleetPolicyRevisionsCleanupTask] Outdated task version: Got [${taskInstance.id}] from task instance. Current version is [${this.taskId}]`);
        return (0, _task.getDeleteTaskRunResult)();
      }
      this.logger.debug(`[FleetPolicyRevisionsCleanupTask] runTask() started`);
      const [coreStart, _startDeps] = await core.getStartServices();
      const esClient = coreStart.elasticsearch.client.asInternalUser;
      try {
        await (0, _cleanup_policy_revisions.cleanupPolicyRevisions)(esClient, {
          abortController,
          logger: this.logger,
          config: {
            maxRevisions: this.maxRevisions,
            maxPolicies: this.maxPoliciesPerRun,
            timeout: TASK_TIMEOUT
          }
        });
        this.endRun('success');
      } catch (err) {
        if (err instanceof _elasticsearch.errors.RequestAbortedError) {
          this.logger.warn(`[FleetPolicyRevisionsCleanupTask] request aborted due to timeout: ${err}`);
          this.endRun();
          return;
        }
        this.logger.error(`[FleetPolicyRevisionsCleanupTask] error: ${err}`);
        this.endRun('error');
      }
    });
    const {
      core: _core,
      taskManager: _taskManager,
      logFactory,
      config
    } = setupContract;
    this.logger = logFactory.get(this.taskId);
    this.taskInterval = (_config$interval = config.interval) !== null && _config$interval !== void 0 ? _config$interval : '1h';
    this.maxRevisions = (_config$maxRevisions = config.maxRevisions) !== null && _config$maxRevisions !== void 0 ? _config$maxRevisions : 10;
    this.maxPoliciesPerRun = (_config$maxPoliciesPe = config.maxPoliciesPerRun) !== null && _config$maxPoliciesPe !== void 0 ? _config$maxPoliciesPe : 100;
    _taskManager.registerTaskDefinitions({
      [TYPE]: {
        title: TITLE,
        timeout: TASK_TIMEOUT,
        createTaskRunner: ({
          taskInstance,
          abortController
        }) => {
          return {
            run: async () => {
              return this.runTask(taskInstance, _core, abortController);
            },
            cancel: async () => {}
          };
        }
      }
    });
  }
  get taskId() {
    return `${TYPE}:${VERSION}`;
  }
  endRun(msg = '') {
    this.logger.debug(`[FleetPolicyRevisionsCleanupTask] runTask ended${msg ? ': ' + msg : ''}`);
  }
}
exports.FleetPolicyRevisionsCleanupTask = FleetPolicyRevisionsCleanupTask;