"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputClient = void 0;
Object.defineProperty(exports, "transformOutputToFullPolicyOutput", {
  enumerable: true,
  get: function () {
    return _full_agent_policy.transformOutputToFullPolicyOutput;
  }
});
var _errors = require("../errors");
var _output = require("./output");
var _full_agent_policy = require("./agent_policies/full_agent_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OutputClient {
  constructor(authz) {
    this.authz = authz;
  }
  async getDefaultDataOutputId() {
    if (!this.authz.fleet.readSettings && !this.authz.fleet.readAgentPolicies) {
      throw new _errors.OutputUnauthorizedError();
    }
    return _output.outputService.getDefaultDataOutputId();
  }
  async get(outputId) {
    if (!this.authz.fleet.readSettings && !this.authz.fleet.readAgentPolicies) {
      throw new _errors.OutputUnauthorizedError();
    }
    return _output.outputService.get(outputId);
  }
}
exports.OutputClient = OutputClient;