"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallPrecheck = stepInstallPrecheck;
var _ensure_fleet_global_es_assets = require("../../../../setup/ensure_fleet_global_es_assets");
var _ = require("../../../..");
var _default_settings = require("../../../elasticsearch/template/default_settings");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallPrecheck() {
  await Promise.all([checkILMMigrationStatus(), ensureFleetGlobalAssets()]);
}
async function ensureFleetGlobalAssets() {
  await (0, _utils.withPackageSpan)('Ensure Fleet Global Assets', () => (0, _ensure_fleet_global_es_assets.ensureFleetGlobalEsAssets)({
    logger: _.appContextService.getLogger(),
    esClient: _.appContextService.getInternalUserESClient(),
    soClient: _.appContextService.getInternalUserSOClient()
  }, {
    reinstallPackages: false
  }));
}
async function checkILMMigrationStatus() {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const isILMPoliciesDisabled = (_appContextService$ge = (_appContextService$ge2 = _.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.disableILMPolicies) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  if (isILMPoliciesDisabled) {
    return;
  }
  await (0, _utils.withPackageSpan)('Check ILM migration status', async () => {
    const ilmMigrationStatusMap = await (0, _default_settings.getILMMigrationStatus)();
    const updatedILMMigrationStatusMap = new Map(ilmMigrationStatusMap);
    const ilmPolicies = await (0, _default_settings.getILMPolicies)(_default_settings.DATA_STREAM_TYPES_DEPRECATED_ILMS);
    for (const dataStreamType of _default_settings.DATA_STREAM_TYPES_DEPRECATED_ILMS) {
      const ilmPolicy = (0, _default_settings.getILMPolicy)(dataStreamType, ilmMigrationStatusMap, ilmPolicies);
      if (ilmPolicy === `${dataStreamType}@lifecycle`) {
        updatedILMMigrationStatusMap.set(dataStreamType, 'success');
      }
    }
    await (0, _default_settings.saveILMMigrationChanges)(updatedILMMigrationStatusMap);
  });
}