"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postHealthCheckHandler = void 0;
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _fleet_server_host = require("../../services/fleet_server_host");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postHealthCheckHandler = async (context, request, response) => {
  const abortController = new AbortController();
  const {
    id
  } = request.body;
  try {
    var _fleetServerHost$host;
    const fleetServerHost = await _fleet_server_host.fleetServerHostService.get(id);
    if (!fleetServerHost || !(fleetServerHost !== null && fleetServerHost !== void 0 && fleetServerHost.host_urls) || (fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$host = fleetServerHost.host_urls) === null || _fleetServerHost$host === void 0 ? void 0 : _fleetServerHost$host.length) === 0) {
      return response.badRequest({
        body: {
          message: `The requested host id ${id} does not have associated host urls.`
        }
      });
    }

    // Sometimes when the host is not online, the request hangs
    // Setting a timeout to abort the request after 5s
    setTimeout(() => {
      abortController.abort();
    }, 5000);
    const host = fleetServerHost.host_urls[0];
    const res = await (0, _nodeFetch.default)(`${host}/api/status`, {
      headers: {
        accept: '*/*'
      },
      method: 'GET',
      signal: abortController.signal
    });
    const bodyRes = await res.json();
    const body = {
      ...bodyRes
    };
    return response.ok({
      body
    });
  } catch (error) {
    if (error.isBoom && error.output.statusCode === 404) {
      return response.notFound({
        body: {
          message: `The requested host id ${request.body.id} does not exist.`
        }
      });
    }

    // when the request is aborted, return offline status
    if (error.name === 'AbortError' || error.message.includes('user aborted')) {
      return response.ok({
        body: {
          status: `OFFLINE`,
          host_id: request.body.id
        }
      });
    }
    throw error;
  }
};
exports.postHealthCheckHandler = postHealthCheckHandler;