"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEuiIconType = void 0;
var _eui = require("@elastic/eui");
var _services = require("../applications/fleet/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEuiIconType = (pkg, basePath, policyTemplate) => {
  var _icons;
  const pkgIcon = (_icons = (policyTemplate || pkg).icons) === null || _icons === void 0 ? void 0 : _icons.find(icon => icon.type === 'image/svg+xml');
  if (!pkgIcon) {
    // If no valid SVG is available, attempt to fallback to built-in EUI icons
    return _eui.ICON_TYPES.find(key => key.toLowerCase() === `logo${pkg.name}`);
  }
  return basePath.prepend(_services.epmRouteService.getFilePath(`/package/${pkg.name}/${pkg.version}${pkgIcon.src}`));
};
exports.getEuiIconType = getEuiIconType;