"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutContext = exports.FlyoutContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/hooks/use_flyout_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const agentFlyoutContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const FlyoutContextProvider = ({
  children
}) => {
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(false);
  const [isFleetServerFlyoutOpen, setIsFleetServerFlyoutOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(agentFlyoutContext.Provider, {
    value: {
      isEnrollmentFlyoutOpen,
      openEnrollmentFlyout: () => {
        setIsEnrollmentFlyoutOpen(true);
      },
      closeEnrollmentFlyout: () => setIsEnrollmentFlyoutOpen(false),
      isFleetServerFlyoutOpen,
      openFleetServerFlyout: () => setIsFleetServerFlyoutOpen(true),
      closeFleetServerFlyout: () => setIsFleetServerFlyoutOpen(false)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, children);
};
exports.FlyoutContextProvider = FlyoutContextProvider;
const useFlyoutContext = () => {
  const context = (0, _react.useContext)(agentFlyoutContext);
  if (!context) {
    throw new Error('useFlyoutContext must be used within a FlyoutContextProvider');
  }
  return context;
};
exports.useFlyoutContext = useFlyoutContext;