"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../../../../../services");
var _constants = require("../../../../../../../../common/constants");
var _components = require("../../../../../components");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _side_bar_column = require("../../../components/side_bar_column");
var _deferred_assets_section = require("./deferred_assets_section");
var _assets_accordion = require("./assets_accordion");
var _install_kibana_assets_button = require("./install_kibana_assets_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/assets/assets.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssetsPage = ({
  packageInfo,
  refetchPackageInfo
}) => {
  var _pkgInstallationInfo$;
  const {
    name,
    version
  } = packageInfo;
  const pkgkey = `${name}-${version}`;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    spaceId
  } = (0, _hooks.useFleetStatus)();
  const config = (0, _hooks.useConfig)();
  const {
    useSpaceAwareness
  } = _services.ExperimentalFeaturesService.get();
  const customAssetsExtension = (0, _hooks.useUIExtension)(packageInfo.name, 'package-detail-assets');
  const canReadPackageSettings = (0, _hooks.useAuthz)().integrations.readPackageInfo;
  const {
    getPath
  } = (0, _hooks.useLink)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const packageInstallStatus = getPackageInstallStatus(packageInfo.name);
  const pkgInstallationInfo = 'installationInfo' in packageInfo ? packageInfo.installationInfo : undefined;
  const installedSpaceId = pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.installed_kibana_space_id;
  const assetsInstalledInCurrentSpace = !installedSpaceId || installedSpaceId === spaceId || (pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : (_pkgInstallationInfo$ = pkgInstallationInfo.additional_spaces_installed_kibana) === null || _pkgInstallationInfo$ === void 0 ? void 0 : _pkgInstallationInfo$[spaceId || 'default']);
  const [assetSavedObjectsByType, setAssetsSavedObjectsByType] = (0, _react.useState)({});
  const [deferredInstallations, setDeferredInstallations] = (0, _react.useState)();
  const kibanaAssets = (0, _react.useMemo)(() => {
    var _pkgInstallationInfo$2;
    return !installedSpaceId || installedSpaceId === spaceId ? (pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.installed_kibana) || [] : (pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : (_pkgInstallationInfo$2 = pkgInstallationInfo.additional_spaces_installed_kibana) === null || _pkgInstallationInfo$2 === void 0 ? void 0 : _pkgInstallationInfo$2[spaceId || 'default']) || [];
  }, [installedSpaceId, spaceId, pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.installed_kibana, pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.additional_spaces_installed_kibana]);
  const pkgAssets = (0, _react.useMemo)(() => [...kibanaAssets, ...((pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.installed_es) || [])], [kibanaAssets, pkgInstallationInfo === null || pkgInstallationInfo === void 0 ? void 0 : pkgInstallationInfo.installed_es]);
  const pkgAssetsByType = (0, _react.useMemo)(() => pkgAssets.reduce((acc, asset) => {
    if (_constants.displayedAssetTypes.includes(asset.type)) {
      if (!acc[asset.type]) {
        acc[asset.type] = [];
      }
      acc[asset.type].push(asset);
    }
    return acc;
  }, {}), [pkgAssets]);
  const [fetchError, setFetchError] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const forceRefreshAssets = (0, _react.useCallback)(() => {
    if (refetchPackageInfo) {
      refetchPackageInfo();
    }
  }, [refetchPackageInfo]);
  (0, _react.useEffect)(() => {
    const fetchAssetSavedObjects = async () => {
      if (!pkgInstallationInfo) {
        setIsLoading(false);
        return;
      }
      if (pkgAssets.length === 0) {
        setIsLoading(false);
        return;
      }
      if (pkgAssets.length > 0) {
        const deferredAssets = pkgAssets.filter(asset => {
          return 'deferred' in asset && asset.deferred === true;
        });
        setDeferredInstallations(deferredAssets);
      }
      try {
        const assetIds = pkgAssets.map(({
          id,
          type
        }) => ({
          id,
          type
        }));
        const {
          data,
          error
        } = await (0, _hooks.sendGetBulkAssets)({
          assetIds
        });
        if (error) {
          setFetchError(error);
        } else {
          setAssetsSavedObjectsByType(((data === null || data === void 0 ? void 0 : data.items) || []).reduce((acc, asset) => {
            if (!acc[asset.type]) {
              acc[asset.type] = {};
            }
            acc[asset.type][asset.id] = asset;
            return acc;
          }, {}));
        }
      } catch (e) {
        setFetchError(e);
      } finally {
        setIsLoading(false);
      }
    };
    fetchAssetSavedObjects();
  }, [packageInfo, pkgAssets, pkgInstallationInfo]);

  // if they arrive at this page and the package is not installed, send them to overview
  // this happens if they arrive with a direct url or they uninstall while on this tab
  if (packageInstallStatus.status !== _types.InstallStatus.installed) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: getPath('integration_details_overview', {
        pkgkey
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 12
      }
    });
  }
  const hasDeferredInstallations = Array.isArray(deferredInstallations) && deferredInstallations.length > 0;
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 15
      }
    });
  } else if (!canReadPackageSettings) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.assets.assetsPermissionErrorTitle",
        defaultMessage: "Permission error",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.assets.assetsPermissionError",
      defaultMessage: "You do not have permission to retrieve the Kibana saved object for that integration. Contact your administrator.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 9
      }
    }));
  } else if (pkgAssets.length === 0) {
    if (customAssetsExtension) {
      // If a UI extension for custom asset entries is defined, render the custom component here despite
      // there being no saved objects found
      content = /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(customAssetsExtension.Component, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 11
        }
      }));
    } else {
      content = !hasDeferredInstallations ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.assets.noAssetsFoundLabel",
        defaultMessage: "No assets found",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 13
        }
      }))) : null;
    }
  } else {
    content = [
    // Show callout if Kibana assets are installed in a different space
    !assetsInstalledInCurrentSpace ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      heading: "h2",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.assets.assetsNotAvailableInCurrentSpaceTitle",
        defaultMessage: "Kibana assets not available in this space",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 227,
          columnNumber: 15
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.assets.assetsNotAvailableInCurrentSpaceBody",
      defaultMessage: "This integration is installed, but Kibana assets are not available in this space. {learnMoreLink}.",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.installAndUninstallIntegrationAssets,
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 239,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetails.assets.assetsNotAvailableInCurrentSpace.learnMore",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 243,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 15
      }
    })), useSpaceAwareness ? /*#__PURE__*/_react.default.createElement(_install_kibana_assets_button.InstallKibanaAssetsButton, {
      installInfo: pkgInstallationInfo,
      title: packageInfo.title,
      onSuccess: forceRefreshAssets,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 15
      }
    }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 11
      }
    })) : null,
    // Ensure we add any custom assets provided via UI extension to the before other assets
    customAssetsExtension ? /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(customAssetsExtension.Component, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 11
      }
    })) : null,
    // List all assets by order of `displayedAssetTypes`
    ..._constants.displayedAssetTypes.map(assetType => {
      if (config !== null && config !== void 0 && config.hideDashboards && assetType === 'dashboard') {
        // If hideDashboards is set, filter out dashboards from displayed assets
        return null;
      }
      const assets = pkgAssetsByType[assetType] || [];
      const soAssets = assetSavedObjectsByType[assetType] || {};
      const finalAssets = assets.map(asset => {
        return {
          ...asset,
          ...soAssets[asset.id]
        };
      });
      if (!finalAssets.length) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: assetType,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_assets_accordion.AssetsAccordion, {
        savedObjects: finalAssets,
        type: assetType,
        key: assetType,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 295,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 13
        }
      }));
    })];
  }
  const deferredInstallationsContent = hasDeferredInstallations ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deferred_assets_section.DeferredAssetsSection, {
    deferredInstallations: deferredInstallations,
    packageInfo: packageInfo,
    forceRefreshAssets: forceRefreshAssets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 7
    }
  }, fetchError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.assets.fetchAssetsErrorTitle",
      defaultMessage: "Error loading complete asset information",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 17
      }
    }),
    error: fetchError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 13
    }
  })), deferredInstallationsContent, content));
};
exports.AssetsPage = AssetsPage;