"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageCard = PackageCard;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/usage-collection-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _deferred_assets_warning = require("../screens/detail/assets/deferred_assets_warning");
var _package_icon = require("../../../../../components/package_icon");
var _components = require("../../../components");
var _hooks = require("../../../hooks");
var _constants = require("../../../constants");
var _installation_status = require("./installation_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/package_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PackageCard({
  description,
  name,
  title,
  version,
  type,
  icons,
  integration,
  url,
  release,
  id,
  fromIntegrations,
  isReauthorizationRequired,
  isUnverified,
  isUpdateAvailable,
  showLabels = true,
  showInstallationStatus,
  showCompressedInstallationStatus,
  extraLabelsBadges,
  isQuickstart = false,
  installStatus,
  onCardClick: onClickProp = undefined,
  isCollectionCard = false,
  titleLineClamp,
  titleBadge,
  titleSize = 'xs',
  descriptionLineClamp,
  maxCardHeight,
  minCardHeight,
  showDescription = true,
  showReleaseBadge = true,
  hasDataStreams
}) {
  const theme = (0, _eui.useEuiTheme)();
  let releaseBadge = null;
  if (release && release !== 'ga' && showReleaseBadge) {
    releaseBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_components.InlineReleaseBadge, {
      release: release,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    })));
  }
  let verifiedBadge = null;
  if (isUnverified && showLabels) {
    verifiedBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.unverifiedLabel",
      defaultMessage: "Unverified",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }))));
  }
  let hasDeferredInstallationsBadge = null;
  if (isReauthorizationRequired && showLabels) {
    hasDeferredInstallationsBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "inlineBlock",
      content: _deferred_assets_warning.DEFERRED_ASSETS_WARNING_MSG,
      title: _deferred_assets_warning.DEFERRED_ASSETS_WARNING_LABEL,
      css: (0, _react2.css)`
              width: 100%;
            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }, _deferred_assets_warning.DEFERRED_ASSETS_WARNING_LABEL, ' '))));
  }
  let updateAvailableBadge = null;
  if (isUpdateAvailable && showLabels) {
    updateAvailableBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "sortUp",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.updateAvailableLabel",
      defaultMessage: "Update available",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 13
      }
    }))));
  }
  let collectionButton = null;
  if (isCollectionCard) {
    collectionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "text",
      "data-test-subj": "xpack.fleet.packageCard.collectionButton",
      iconType: "package",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.collectionButton.copy",
      defaultMessage: "View collection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    })));
  }
  let contentBadge = null;
  if (type === 'content') {
    contentBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.contentPackageLabel",
      defaultMessage: "Content only",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }))));
  }
  const {
    application
  } = (0, _hooks.useStartServices)();
  const onCardClick = () => {
    if (url.startsWith(_constants.INTEGRATIONS_BASE_PATH)) {
      application.navigateToApp(_constants.INTEGRATIONS_PLUGIN_ID, {
        path: url.slice(_constants.INTEGRATIONS_BASE_PATH.length),
        state: {
          fromIntegrations
        }
      });
    } else if (url.startsWith('http') || url.startsWith('https')) {
      window.open(url, '_blank');
    } else {
      application.navigateToUrl(url);
    }
  };
  const installationStatusVisible = (0, _installation_status.shouldShowInstallationStatus)({
    installStatus,
    showInstallationStatus,
    isActive: hasDataStreams
  });
  const testid = `integration-card:${id}`;
  return /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: testid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard
  // EUI TODO: Custom component CSS
  // Min-height is roughly 3 lines of content.
  // This keeps the cards from looking overly unbalanced because of content differences.
  , {
    css: (0, _react2.css)`
          position: relative;
          [class*='euiCard__content'] {
            display: flex;
            flex-direction: column;
            block-size: 100%;
            overflow: hidden;
          }

          [class*='euiCard__description'] {
            flex-grow: 1;
            ${descriptionLineClamp ? installationStatusVisible ? (0, _installation_status.getLineClampStyles)(1) // Show only one line of description if installation status is shown
    : (0, _installation_status.getLineClampStyles)(descriptionLineClamp) : ''}
          }

          [class*='euiCard__titleButton'] {
            width: ${installationStatusVisible ? `calc(100% - ${theme.euiTheme.base * 4}px)` : '100%'};
            ${(0, _installation_status.getLineClampStyles)(titleLineClamp)}
          }

          min-height: ${minCardHeight ? `${minCardHeight}px` : '127px'};
          border-color: ${isQuickstart ? theme.euiTheme.colors.accent : null};
          max-height: ${maxCardHeight ? `${maxCardHeight}px` : null};
          overflow: ${maxCardHeight ? 'hidden' : null};
        `,
    "data-test-subj": testid,
    betaBadgeProps: quickstartBadge(isQuickstart),
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement(CardTitle, {
      title: title,
      titleBadge: titleBadge,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 16
      }
    }),
    titleSize: titleSize,
    description: showDescription ? description : '',
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_package_icon.CardIcon, {
      icons: icons,
      packageName: name,
      integrationName: integration,
      version: version,
      size: showDescription ? 'xl' : 'xxl',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 11
      }
    }),
    onClick: onClickProp !== null && onClickProp !== void 0 ? onClickProp : onCardClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true,
    css: (0, _react2.css)`
            width: ${installationStatusVisible ? `calc(100% - ${theme.euiTheme.base * 4}px)` : '100%'};
            overflow-x: hidden;
            text-overflow: ellipsis;

            & > .euiFlexItem {
              min-width: 0;
            }

            ${isCollectionCard ? `& > .euiFlexItem:last-child {
              min-width: auto;
            }` : ''}
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, showLabels && extraLabelsBadges ? extraLabelsBadges : null, verifiedBadge, updateAvailableBadge, contentBadge, releaseBadge, hasDeferredInstallationsBadge, collectionButton, /*#__PURE__*/_react.default.createElement(_installation_status.InstallationStatus, {
    installStatus: installStatus,
    showInstallationStatus: showInstallationStatus,
    compressed: showCompressedInstallationStatus,
    hasDataStreams: hasDataStreams,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }))));
}
const CardTitle = /*#__PURE__*/_react.default.memo(({
  title,
  titleBadge
}) => {
  if (!titleBadge) {
    return title;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 9
    }
  }, titleBadge));
});
function quickstartBadge(isQuickstart) {
  return isQuickstart ? {
    label: _i18n.i18n.translate('xpack.fleet.packageCard.quickstartBadge.label', {
      defaultMessage: 'Quickstart'
    }),
    color: 'accent'
  } : undefined;
}