"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultOutputBadge = exports.DefaultMonitoringOutputBadge = exports.DefaultBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/outputs_table/badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DefaultBadges = exports.DefaultBadges = /*#__PURE__*/_react.default.memo(({
  output
}) => {
  const badges = (0, _react.useMemo)(() => {
    const badgesArray = [];
    if (output.is_default) {
      badgesArray.push(/*#__PURE__*/_react.default.createElement(DefaultOutputBadge, {
        key: "default-output",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 20,
          columnNumber: 24
        }
      }));
    }
    if (output.is_default_monitoring) {
      badgesArray.push(/*#__PURE__*/_react.default.createElement(DefaultMonitoringOutputBadge, {
        key: "default-monitoring-output",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 24
        }
      }));
    }
    return badgesArray;
  }, [output]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 10
    }
  }, badges.map((badge, idx) => badge));
});
const DefaultOutputBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.outputs.defaultOutputBadgeTitle",
  defaultMessage: "Agent integrations",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 5
  }
}));
exports.DefaultOutputBadge = DefaultOutputBadge;
const DefaultMonitoringOutputBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.outputs.defaultMonitoringOutputBadgeTitle",
  defaultMessage: "Agent monitoring",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}));
exports.DefaultMonitoringOutputBadge = DefaultMonitoringOutputBadge;