"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmEnrollmentTokenDelete = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/enrollment_token_list_page/components/confirm_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmEnrollmentTokenDelete = props => {
  const {
    onCancel,
    onConfirm,
    enrollmentKey
  } = props;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.fleet.enrollmentTokenDeleteModal.title', {
      defaultMessage: 'Revoke enrollment token'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.enrollmentTokenDeleteModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.enrollmentTokenDeleteModal.deleteButton', {
      defaultMessage: 'Revoke enrollment token'
    }),
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentTokenDeleteModal.description', {
      defaultMessage: 'Are you sure you want to revoke {keyName}? New agents will no longer be able to be enrolled using this token.',
      values: {
        keyName: enrollmentKey.name
      }
    }),
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};
exports.ConfirmEnrollmentTokenDelete = ConfirmEnrollmentTokenDelete;