"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExportCSV = useExportCSV;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _reportingPublic = require("@kbn/reporting-public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../hooks");
var _common2 = require("../../../../../../../common");
var _use_fetch_agents_data = require("./use_fetch_agents_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/hooks/export_csv.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function useExportCSV() {
  const startServices = (0, _hooks.useStartServices)();
  const {
    notifications,
    http,
    uiSettings
  } = startServices;
  const kibanaVersion = (0, _hooks.useKibanaVersion)();
  const {
    data: runtimeFieldsResponse
  } = (0, _hooks.useGetAgentStatusRuntimeFieldQuery)({
    enabled: true
  });
  const runtimeFields = runtimeFieldsResponse ? runtimeFieldsResponse : 'emit("")';
  const getJobParams = (agents, columns, sortOptions) => {
    var _sortOptions$field, _ref;
    const index = new _common.DataView({
      spec: {
        title: '.fleet-agents',
        allowHidden: true,
        runtimeFieldMap: {
          status: {
            type: 'keyword',
            script: {
              source: runtimeFields
            }
          }
        }
      },
      fieldFormats: {}
    });
    let query;
    if (Array.isArray(agents)) {
      query = `agent.id:(${agents.map(agent => agent.id).join(' OR ')})`;
    } else {
      query = agents;
    }
    const sortField = (0, _use_fetch_agents_data.getSortFieldForAPI)((_sortOptions$field = sortOptions === null || sortOptions === void 0 ? void 0 : sortOptions.field) !== null && _sortOptions$field !== void 0 ? _sortOptions$field : 'enrolled_at');
    const sortOrder = (_ref = sortOptions === null || sortOptions === void 0 ? void 0 : sortOptions.direction) !== null && _ref !== void 0 ? _ref : _common.SortDirection.desc;
    const sort = (0, _common2.getSortConfig)(sortField, sortOrder);
    const searchSource = {
      query: {
        query: '',
        language: 'kuery'
      },
      filter: {
        meta: {
          index: 'fleet-agents',
          params: {}
        },
        query: (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)((0, _common2.removeSOAttributes)(query)))
      },
      fields: columns,
      index,
      sort
    };
    return {
      title: 'Agent List',
      objectType: 'search',
      columns: columns.map(column => column.field),
      searchSource
    };
  };
  const apiClient = new _reportingPublic.ReportingAPIClient(http, uiSettings, kibanaVersion);

  // copied and adapted logic from here: https://github.com/elastic/kibana/blob/2846a162de7e56d2107eeb2e33e006a3310a4ae1/packages/kbn-reporting/public/share/share_context_menu/register_csv_modal_reporting.tsx#L86
  const generateReportingJobCSV = (agents, columns, sortOptions) => {
    const decoratedJobParams = apiClient.getDecoratedJobParams(getJobParams(agents, columns, sortOptions));
    return apiClient.createReportingShareJob('csv_searchsource', decoratedJobParams).then(() => {
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.modalContent.successfullyQueuedReportNotificationTitle', {
          defaultMessage: 'Queued report for CSV'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.modalContent.successfullyQueuedReportNotificationDescription",
          defaultMessage: "Track its progress in {path}.",
          values: {
            path: /*#__PURE__*/_react.default.createElement("a", {
              href: apiClient.getManagementLink(),
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 122,
                columnNumber: 19
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.publicNotifier.reportLink.reportingSectionUrlLinkLabel",
              defaultMessage: "Stack Management > Reporting",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 123,
                columnNumber: 21
              }
            }))
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 13
          }
        }), startServices),
        'data-test-subj': 'queueReportSuccess'
      });
    }).catch(error => {
      var _error$body;
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.modalContent.notification.reportingErrorTitle', {
          defaultMessage: 'Unable to create report'
        }),
        toastMessage:
        /*#__PURE__*/
        // eslint-disable-next-line react/no-danger
        _react.default.createElement("span", {
          dangerouslySetInnerHTML: {
            __html: (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 13
          }
        })
      });
    });
  };
  return {
    generateReportingJobCSV
  };
}