"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyEditorDatastreamMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../../../../common/services");
var _hooks = require("../../../../hooks");
var _datastream_hooks = require("./datastream_hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/datastream_mappings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useComponentTemplates(dataStream) {
  const customComponentTemplateRes = (0, _hooks.useGetComponentTemplateQuery)((0, _services.getComponentTemplateNameForDatastream)(dataStream, '@custom'));
  const hasCustom = !!customComponentTemplateRes.data;
  const componentTemplateItems = (0, _react.useMemo)(() => {
    return [{
      templateName: (0, _services.getComponentTemplateNameForDatastream)(dataStream, '@package'),
      canEdit: false
    }, ...(hasCustom ? [{
      templateName: (0, _services.getComponentTemplateNameForDatastream)(dataStream, '@custom'),
      canEdit: true
    }] : [])];
  }, [dataStream, hasCustom]);
  return {
    isLoading: customComponentTemplateRes.isLoading,
    hasCustom,
    componentTemplateItems
  };
}
const PackagePolicyEditorDatastreamMappings = ({
  packageInputStream,
  packageInfo,
  customDataset
}) => {
  const dataStream = customDataset ? {
    ...packageInputStream.data_stream,
    dataset: customDataset
  } : packageInputStream.data_stream;
  const pageUrl = (0, _datastream_hooks.usePackagePolicyEditorPageUrl)(packageInputStream.id);
  const {
    application,
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    componentTemplateItems,
    hasCustom,
    isLoading
  } = useComponentTemplates(dataStream);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamMappings.title",
    defaultMessage: "Mappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamMappings.description",
    defaultMessage: "Mapping is the process of defining how a document, and the fields it contains, are stored and indexed. If you are adding new fields through custom ingest pipeline, we recommend addition of a mapping for those in the component template. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.datastreams,
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.packagePolicyEditor.datastreamMappings.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: componentTemplateItems,
    columns: [{
      field: 'templateName',
      name: ''
    }, {
      width: '60px',
      actions: [{
        icon: 'pencil',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.datastreamMappings.editBtn', {
          defaultMessage: 'Edit mappings'
        }),
        'data-test-subj': 'datastreamEditMappingsBtn',
        name: 'edit',
        isPrimary: true,
        onClick: async el => {
          const url = application.getUrlForApp('management', {
            path: `/data/index_management/edit_component_template/${el.templateName}`
          });
          application.navigateToUrl(`${url}?step=mappings&redirect_path=${pageUrl}`);
        },
        available: ({
          canEdit
        }) => !!canEdit
      }, {
        icon: 'inspect',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.datastreamMappings.inspectBtn', {
          defaultMessage: 'Inspect mappings'
        }),
        name: 'inspect',
        'data-test-subj': 'datastreamInspectMappingsBtn',
        isPrimary: true,
        onClick: async el => {
          const url = application.getUrlForApp('management', {
            path: `/data/index_management/component_templates/${el.templateName}`
          });
          application.navigateToUrl(`${url}?redirect_path=${pageUrl}`);
        }
      }]
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })), !isLoading && !hasCustom && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    iconType: "plusInCircle",
    "data-test-subj": "datastreamAddCustomComponentTemplateBtn",
    onClick: async () => {
      const url = application.getUrlForApp('management', {
        path: `/data/index_management/create_component_template`
      });
      const name = (0, _services.getComponentTemplateNameForDatastream)(dataStream, '@custom');
      application.navigateToUrl(`${url}?name=${name}&step=mappings&redirect_path=${pageUrl}`);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamMappings.addCustomButn",
    defaultMessage: "Add custom mappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }))));
};
exports.PackagePolicyEditorDatastreamMappings = PackagePolicyEditorDatastreamMappings;