"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeployAgentPolicyModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/confirm_deploy_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmDeployAgentPolicyModal = ({
  onConfirm,
  onCancel,
  agentCount,
  agentPolicies,
  agentPoliciesToAdd = [],
  agentPoliciesToRemove = []
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return agentPolicies.length === 0 && agentPoliciesToRemove.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.noPolicies.confirmModalTitle",
      defaultMessage: "Save changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.noPolicies.confirmModalCancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.noPolicies.confirmModalConfirmButtonLabel",
      defaultMessage: "Save changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }),
    buttonColor: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    "data-test-subj": "confirmNoPoliciesCallout",
    title: _i18n.i18n.translate('xpack.fleet.agentPolicy.noPolicies.confirmModalCalloutTitle', {
      defaultMessage: 'No agent policies selected'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.noPolicies.confirmModalCalloutDescription",
    defaultMessage: "This integration will not be added to any agent policies.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalTitle",
      defaultMessage: "Save and deploy changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalCancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalConfirmButtonLabel",
      defaultMessage: "Save and deploy changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }),
    buttonColor: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, agentCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    title: _i18n.i18n.translate('xpack.fleet.agentPolicy.confirmModalCalloutTitle', {
      defaultMessage: 'This action will update {agentCount, plural, one {# agent} other {# agents}}',
      values: {
        agentCount
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalCalloutDescription",
    defaultMessage: "Fleet has detected that the selected agent policies, {policyNames}, are already in use by some of your agents. As a result of this action, Fleet will deploy updates to all agents that use these policies.",
    values: {
      policyNames: /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 30
        }
      }, agentPolicies.map(policy => policy.name).join(', '))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    "data-test-subj": "confirmAddRemovePoliciesCallout",
    iconType: "info",
    title: _i18n.i18n.translate('xpack.fleet.agentPolicy.confirmModalPoliciesCalloutTitle', {
      defaultMessage: 'This action will update the selected agent policies'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, agentPoliciesToAdd.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalPoliciesAddCalloutDescription",
    defaultMessage: "Agent policies that will be updated to use this integration policy:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, agentPoliciesToAdd.map(policy => /*#__PURE__*/_react.default.createElement("li", {
    key: policy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 19
    }
  }, policy)))), agentPoliciesToRemove.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalPoliciesRemoveCalloutDescription",
    defaultMessage: "Agent policies that will be updated to remove this integration policy:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  }, agentPoliciesToRemove.map(policy => /*#__PURE__*/_react.default.createElement("li", {
    key: policy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }, policy))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalDescription",
    defaultMessage: "This action can not be undone. Are you sure you wish to continue?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }));
};
exports.ConfirmDeployAgentPolicyModal = ConfirmDeployAgentPolicyModal;