"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicyFormContext = exports.AgentPolicyForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _settings = require("../../../../../../common/settings");
var _hooks = require("../../../../../hooks");
var _form_settings = require("../../../components/form_settings");
var _agent_policy_advanced_fields = require("./agent_policy_advanced_fields");
var _agent_policy_general_fields = require("./agent_policy_general_fields");
var _agent_policy_system_monitoring_field = require("./agent_policy_system_monitoring_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .ingest-active-button {
    color: ${props => props.theme.eui.euiColorPrimary};
  }
`;
const AgentPolicyFormContext = /*#__PURE__*/_react.default.createContext(undefined);
const useAgentPolicyFormContext = () => {
  return _react.default.useContext(AgentPolicyFormContext);
};
exports.useAgentPolicyFormContext = useAgentPolicyFormContext;
const AgentPolicyForm = ({
  agentPolicy,
  updateAgentPolicy,
  withSysMonitoring,
  updateSysMonitoring,
  validation,
  isEditing = false,
  updateAdvancedSettingsHasErrors,
  setInvalidSpaceError
}) => {
  const authz = (0, _hooks.useAuthz)();
  const isDisabled = !authz.fleet.allAgentPolicies;
  const generalSettingsWrapper = children => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyForm.generalSettingsGroupTitle",
      defaultMessage: "General settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyForm.generalSettingsGroupDescription",
      defaultMessage: "Choose a name and description for your agent policy.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, children);
  return /*#__PURE__*/_react.default.createElement(AgentPolicyFormContext.Provider, {
    value: {
      agentPolicy,
      updateAgentPolicy,
      updateAdvancedSettingsHasErrors,
      setInvalidSpaceError
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, !isEditing ? /*#__PURE__*/_react.default.createElement(_agent_policy_general_fields.AgentPolicyGeneralFields, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }) : generalSettingsWrapper([/*#__PURE__*/_react.default.createElement(_agent_policy_general_fields.AgentPolicyGeneralFields, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  })]), !isEditing ? /*#__PURE__*/_react.default.createElement(_agent_policy_system_monitoring_field.AgentPolicyFormSystemMonitoringCheckbox, {
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: updateSysMonitoring,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }) : null, !isEditing ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "advancedOptions",
    "data-test-subj": "advancedOptionsButton",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.advancedOptionsToggleLabel",
      defaultMessage: "Advanced options",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 17
      }
    }),
    buttonClassName: "ingest-active-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_advanced_fields.AgentPolicyAdvancedOptionsContent, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    setInvalidSpaceError: setInvalidSpaceError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.advancedSettingsTitle",
    defaultMessage: "Advanced settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_form_settings.ConfiguredSettings, {
    configuredSettings: _settings.AGENT_POLICY_ADVANCED_SETTINGS,
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_agent_policy_advanced_fields.AgentPolicyAdvancedOptionsContent, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    setInvalidSpaceError: setInvalidSpaceError,
    disabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyForm.advancedSettingsTitle",
    defaultMessage: "Advanced settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_form_settings.ConfiguredSettings, {
    configuredSettings: _settings.AGENT_POLICY_ADVANCED_SETTINGS,
    disabled: isDisabled || !!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless) || !!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }))));
};
exports.AgentPolicyForm = AgentPolicyForm;