"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_SELECT_VALUE = void 0;
exports.useDownloadSourcesOptions = useDownloadSourcesOptions;
exports.useFleetServerHostsOptions = useFleetServerHostsOptions;
exports.useOutputOptions = useOutputOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../../common/constants");
var _services = require("../../../../../../../common/services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_advanced_fields/hooks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// The super select component do not support null or '' as a value
const DEFAULT_SELECT_VALUE = exports.DEFAULT_SELECT_VALUE = '@@##DEFAULT_SELECT##@@';
function getOutputLabel(name, disabledMessage) {
  if (!disabledMessage) {
    return name;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, disabledMessage));
}
function getDefaultOutput(defaultOutputName, defaultOutputDisabled, defaultOutputDisabledMessage) {
  return {
    inputDisplay: getOutputLabel(_i18n.i18n.translate('xpack.fleet.agentPolicy.outputOptions.defaultOutputText', {
      defaultMessage: 'Default (currently {defaultOutputName})',
      values: {
        defaultOutputName
      }
    }), defaultOutputDisabledMessage),
    value: DEFAULT_SELECT_VALUE,
    disabled: defaultOutputDisabled
  };
}
function useOutputOptions(agentPolicy) {
  const outputsRequest = (0, _hooks.useGetOutputs)();
  const licenseService = (0, _hooks.useLicense)();

  // Allow changing output when agent policy has fleet server or synthetics integrations
  // regardless of license level
  const isPolicyPerOutputAllowed = licenseService.hasAtLeast(_constants.LICENCE_FOR_PER_POLICY_OUTPUT) || (0, _services.policyHasFleetServer)(agentPolicy) || (0, _services.policyHasSyntheticsIntegration)(agentPolicy);
  const allowedOutputTypes = (0, _react.useMemo)(() => (0, _services.getAllowedOutputTypesForAgentPolicy)(agentPolicy), [agentPolicy]);
  const dataOutputOptions = (0, _react.useMemo)(() => {
    if (outputsRequest.isLoading || !outputsRequest.data) {
      return [];
    }
    if (outputsRequest.isLoading || !outputsRequest.data) {
      return [];
    }
    const defaultOutput = outputsRequest.data.items.find(item => item.is_default);
    const defaultOutputName = defaultOutput === null || defaultOutput === void 0 ? void 0 : defaultOutput.name;
    const defaultOutputDisabled = (defaultOutput === null || defaultOutput === void 0 ? void 0 : defaultOutput.type) && !allowedOutputTypes.includes(defaultOutput.type);
    const defaultOutputDisabledMessage = defaultOutputDisabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.outputOptionDisableOutputTypeText",
      defaultMessage: "{outputType} output for agent integration is not supported for this policy.",
      values: {
        outputType: defaultOutput.type
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }) : undefined;
    return [getDefaultOutput(defaultOutputName, defaultOutputDisabled, defaultOutputDisabledMessage), ...outputsRequest.data.items.map(item => {
      const isOutputTypeUnsupported = !allowedOutputTypes.includes(item.type);
      const isInternalOutput = !!item.is_internal;
      return {
        value: item.id,
        inputDisplay: getOutputLabel(item.name, isOutputTypeUnsupported ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyForm.outputOptionDisabledTypeNotSupportedText",
          defaultMessage: "{outputType} output for agent integration is not supported for this policy.",
          values: {
            outputType: item.type
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 15
          }
        }) : undefined),
        disabled: !isPolicyPerOutputAllowed || isOutputTypeUnsupported || isInternalOutput
      };
    })];
  }, [outputsRequest, isPolicyPerOutputAllowed, allowedOutputTypes]);
  const monitoringOutputOptions = (0, _react.useMemo)(() => {
    var _outputsRequest$data$;
    if (outputsRequest.isLoading || !outputsRequest.data) {
      return [];
    }
    const defaultOutputName = (_outputsRequest$data$ = outputsRequest.data.items.find(item => item.is_default_monitoring)) === null || _outputsRequest$data$ === void 0 ? void 0 : _outputsRequest$data$.name;
    return [getDefaultOutput(defaultOutputName), ...outputsRequest.data.items.map(item => {
      const isInternalOutput = !!item.is_internal;
      return {
        value: item.id,
        inputDisplay: item.name,
        disabled: !isPolicyPerOutputAllowed || isInternalOutput
      };
    })];
  }, [outputsRequest, isPolicyPerOutputAllowed]);
  const dataOutputValueOfSelected = agentPolicy.data_output_id || DEFAULT_SELECT_VALUE;
  return (0, _react.useMemo)(() => ({
    dataOutputOptions,
    monitoringOutputOptions,
    dataOutputValueOfSelected,
    isLoading: outputsRequest.isLoading
  }), [dataOutputOptions, dataOutputValueOfSelected, monitoringOutputOptions, outputsRequest.isLoading]);
}
function useDownloadSourcesOptions() {
  const downloadSourcesRequest = (0, _hooks.useGetDownloadSources)();
  const dataDownloadSourceOptions = (0, _react.useMemo)(() => {
    if (downloadSourcesRequest.isLoading || !downloadSourcesRequest.data) {
      return [];
    }
    const defaultDownloadSource = downloadSourcesRequest.data.items.find(item => item.is_default);
    const defaultDownloadSourceName = defaultDownloadSource === null || defaultDownloadSource === void 0 ? void 0 : defaultDownloadSource.name;
    return [getDefaultDownloadSource(defaultDownloadSourceName), ...downloadSourcesRequest.data.items.map(item => {
      return {
        value: item.id,
        inputDisplay: item.name
      };
    })];
  }, [downloadSourcesRequest]);
  return (0, _react.useMemo)(() => ({
    dataDownloadSourceOptions,
    isLoading: downloadSourcesRequest.isLoading
  }), [dataDownloadSourceOptions, downloadSourcesRequest.isLoading]);
}
function getDefaultDownloadSource(defaultDownloadSourceName, defaultDownloadSourceDisabled, defaultDownloadSourceDisabledMessage) {
  return {
    inputDisplay: getOutputLabel(_i18n.i18n.translate('xpack.fleet.agentPolicy.downloadSourcesOptions.defaultOutputText', {
      defaultMessage: 'Default (currently {defaultDownloadSourceName})',
      values: {
        defaultDownloadSourceName
      }
    }), defaultDownloadSourceDisabledMessage),
    value: DEFAULT_SELECT_VALUE,
    disabled: defaultDownloadSourceDisabled
  };
}
function useFleetServerHostsOptions(agentPolicy) {
  const fleetServerHostsRequest = (0, _hooks.useGetFleetServerHosts)();
  const fleetServerHostsOptions = (0, _react.useMemo)(() => {
    if (fleetServerHostsRequest.isLoading || !fleetServerHostsRequest.data) {
      return [];
    }
    const defaultFleetServerHosts = fleetServerHostsRequest.data.items.find(item => item.is_default);
    const defaultFleetServerHostsName = defaultFleetServerHosts === null || defaultFleetServerHosts === void 0 ? void 0 : defaultFleetServerHosts.name;
    return [getDefaultFleetServerHosts(defaultFleetServerHostsName), ...fleetServerHostsRequest.data.items.map(item => {
      const isInternalFleetServerHost = !!item.is_internal;
      return {
        value: item.id,
        inputDisplay: item.name,
        disabled: isInternalFleetServerHost
      };
    })];
  }, [fleetServerHostsRequest]);
  return (0, _react.useMemo)(() => ({
    fleetServerHostsOptions,
    isLoading: fleetServerHostsRequest.isLoading
  }), [fleetServerHostsOptions, fleetServerHostsRequest.isLoading]);
}
function getDefaultFleetServerHosts(defaultFleetServerHostsName, defaultFleetServerHostsDisabled, defaultFleetServerHostsDisabledMessage) {
  return {
    inputDisplay: getOutputLabel(_i18n.i18n.translate('xpack.fleet.agentPolicy.fleetServerHostsOptions.defaultOutputText', {
      defaultMessage: 'Default (currently {defaultFleetServerHostsName})',
      values: {
        defaultFleetServerHostsName
      }
    }), defaultFleetServerHostsDisabledMessage),
    value: DEFAULT_SELECT_VALUE,
    disabled: defaultFleetServerHostsDisabled
  };
}