"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FILES_SHARE_API_BASE_PATH = exports.FILES_PUBLIC_API_BASE_PATH = exports.FILES_API_BASE_PATH = exports.API_BASE_PATH = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const API_BASE_PATH = exports.API_BASE_PATH = `/api/${_constants.PLUGIN_ID}`;
const FILES_API_BASE_PATH = exports.FILES_API_BASE_PATH = `${API_BASE_PATH}/files`;
const FILES_SHARE_API_BASE_PATH = exports.FILES_SHARE_API_BASE_PATH = `${API_BASE_PATH}/shares`;
const FILES_PUBLIC_API_BASE_PATH = exports.FILES_PUBLIC_API_BASE_PATH = `${API_BASE_PATH}/public`;

/**
 * Use this when creating file service endpoints to ensure that the client methods
 * are receiving the types they expect as well as providing the expected inputs.
 *
 * For example, consider create route:
 *
 * const rt = configSchema.object({...});
 *
 * export type Endpoint<M = unknown> = CreateRouteDefinition<
 *   typeof rt,              // We pass in our runtime types
 *   { file: FileJSON<M> },  // We pass in return type
 *   FilesClient['create']   // We pass in client method
 * >;
 *
 * This will return `unknown` for param, query or body if client-server types
 * are out-of-sync.
 *
 * The very best would be if the client was auto-generated from the server
 * endpoint declarations.
 */