"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricVisRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _analytics = require("@kbn/analytics");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _visualizationsCommon = require("@kbn/visualizations-common");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _react2 = require("@emotion/react");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_legacy_metric/public/expression_renderers/metric_vis_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// @ts-ignore
const MetricVisComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/metric_component'))));
async function metricFilterable(dimensions, table, handlers) {
  return Promise.all(dimensions.metrics.map(async metric => {
    var _handlers$hasCompatib;
    const column = (0, _chartExpressionsCommon.getColumnByAccessor)(metric, table.columns);
    const colIndex = table.columns.indexOf(column);
    return Boolean(await ((_handlers$hasCompatib = handlers.hasCompatibleActions) === null || _handlers$hasCompatib === void 0 ? void 0 : _handlers$hasCompatib.call(handlers, {
      name: 'filter',
      data: {
        data: [{
          table,
          column: colIndex,
          row: 0
        }]
      }
    })));
  }));
}

/** @internal **/

const getMetricVisRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_METRIC_NAME,
  displayName: 'metric visualization',
  reuseDomNode: true,
  render: async (domNode, {
    visData,
    visConfig,
    canNavigateToLens
  }, handlers) => {
    var _visData$rows;
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const filterable = await metricFilterable(visConfig.dimensions, visData, handlers);
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_legacy_metric`, canNavigateToLens ? `render_${visualizationType}_legacy_metric_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const chartSizeEvent = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          x: {
            value: 100,
            unit: 'percentage'
          },
          y: {
            value: 100,
            unit: 'percentage'
          }
        }
      }
    };
    handlers.event(chartSizeEvent);
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_visualizationsCommon.VisualizationContainer, {
      "data-test-subj": "legacyMtrVis",
      className: "eui-scrollBar legacyMtrVis",
      showNoResult: !((_visData$rows = visData.rows) !== null && _visData$rows !== void 0 && _visData$rows.length),
      renderComplete: renderComplete,
      handlers: handlers,
      css: legacyMtrVisCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(MetricVisComponent, {
      visData: visData,
      visParams: visConfig,
      renderComplete: renderComplete,
      fireEvent: handlers.event,
      filterable: filterable,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }))), domNode);
  }
});
exports.getMetricVisRenderer = getMetricVisRenderer;
const legacyMtrVisCss = (0, _react2.css)({
  height: '100%',
  width: '100%',
  display: 'flex',
  flexDirection: 'row',
  justifyContent: 'center',
  alignItems: 'center',
  flexWrap: 'wrap',
  overflow: 'auto'
});