"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewContext = void 0;
exports.DataViewContextProvider = DataViewContextProvider;
exports.useAppDataViewContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-views-plugin/common");
var _observability_data_views = require("../../../../utils/observability_data_views");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/hooks/use_app_data_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataViewContext = exports.DataViewContext = /*#__PURE__*/(0, _react.createContext)({});
function DataViewContextProvider({
  children
}) {
  const [loading, setLoading] = (0, _react.useState)({});
  const [dataViews, setDataViews] = (0, _react.useState)({});
  const [dataViewErrors, setDataViewErrors] = (0, _react.useState)({});
  const [hasAppData, setHasAppData] = (0, _react.useState)({});
  const {
    services: {
      dataViews: dataViewsService
    }
  } = (0, _public.useKibana)();
  const loadDataView = (0, _react.useCallback)(async ({
    dataType
  }) => {
    if (typeof hasAppData[dataType] === 'undefined' && !loading[dataType]) {
      setLoading(prevState => ({
        ...prevState,
        [dataType]: true
      }));
      try {
        const {
          indices,
          hasData
        } = await (0, _observability_data_views.getDataTypeIndices)(dataType);
        setHasAppData(prevState => ({
          ...prevState,
          [dataType]: hasData
        }));
        if (hasData && indices) {
          const obsvDataV = new _observability_data_views.ObservabilityDataViews(dataViewsService, true);
          const dataV = await obsvDataV.getDataView(dataType, indices);
          setDataViews(prevState => ({
            ...prevState,
            [dataType]: dataV
          }));
        }
        setLoading(prevState => ({
          ...prevState,
          [dataType]: false
        }));
      } catch (e) {
        if (e instanceof _common.DataViewInsufficientAccessError || e.body === 'Forbidden') {
          setDataViewErrors(prevState => ({
            ...prevState,
            [dataType]: e
          }));
        }
        setLoading(prevState => ({
          ...prevState,
          [dataType]: false
        }));
      }
    }
  }, [dataViewsService, hasAppData, loading]);
  return /*#__PURE__*/_react.default.createElement(DataViewContext.Provider, {
    value: {
      hasAppData,
      dataViews,
      loadDataView,
      dataViewErrors,
      loading: !!Object.values(loading).find(loadingT => loadingT)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, children);
}
const useAppDataViewContext = dataType => {
  const {
    loading,
    hasAppData,
    loadDataView,
    dataViews,
    dataViewErrors
  } = (0, _react.useContext)(DataViewContext);
  if (dataType && !(dataViews !== null && dataViews !== void 0 && dataViews[dataType]) && !loading) {
    loadDataView({
      dataType
    });
  }
  return (0, _react.useMemo)(() => {
    return {
      hasAppData,
      loading,
      dataViews,
      dataViewErrors,
      dataView: dataType ? dataViews === null || dataViews === void 0 ? void 0 : dataViews[dataType] : undefined,
      hasData: dataType ? hasAppData === null || hasAppData === void 0 ? void 0 : hasAppData[dataType] : undefined,
      loadDataView
    };
  }, [dataType, hasAppData, dataViewErrors, dataViews, loadDataView, loading]);
};
exports.useAppDataViewContext = useAppDataViewContext;