"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupSavedObjects = setupSavedObjects;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _server = require("@kbn/core/server");
var _common = require("@kbn/data-views-plugin/common");
var _visualizationsCommon = require("@kbn/visualizations-common");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function setupSavedObjects(coreSetup) {
  coreSetup.savedObjects.registerType({
    name: _eventAnnotationCommon.EVENT_ANNOTATION_GROUP_TYPE,
    indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'multiple',
    management: {
      icon: 'flag',
      defaultSearchField: 'title',
      importableAndExportable: true,
      getTitle: obj => obj.attributes.title,
      getInAppUrl: obj => ({
        // TODO link to specific object
        path: `/app/${_visualizationsCommon.VISUALIZE_APP_NAME}#/${_constants.ANNOTATIONS_LISTING_VIEW_ID}`,
        uiCapabilitiesPath: 'visualize_v2.show'
      })
    },
    migrations: () => {
      const dataViewMigrations = _common.DataViewPersistableStateService.getAllMigrations();
      return (0, _server.mergeSavedObjectMigrationMaps)(eventAnnotationGroupMigrations, dataViewMigrations);
    },
    mappings: {
      dynamic: false,
      properties: {
        title: {
          type: 'text'
        },
        description: {
          type: 'text'
        }
      }
    }
  });
}
const eventAnnotationGroupMigrations = {};