"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.keep = keep;
var _append = require("../pipeline/append");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Appends a `KEEP` command to the ESQL composer pipeline.
 *
 * @param columns The columns to keep.
 * @returns A `QueryPipeline` instance with the `KEEP` command appended.
 */
function keep(...columns) {
  const command = `KEEP ${columns.flatMap(column => column).join(', ')}`;
  return (0, _append.append)({
    command
  });
}