"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.from = from;
exports.timeseries = timeseries;
var _esqlAst = require("@kbn/esql-ast");
var _create_pipeline = require("../pipeline/create_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The entry point for the ESQL composer pipeline. Creates a new query
 * starting with a `FROM` or `TS` clause.
 *
 * @param patterns The index patterns to query.
 * @returns A `QueryPipeline` instance to which other composer commands can be chained.
 */

function buildPipeline(command, ...patterns) {
  const allPatterns = patterns.flat();
  const {
    root
  } = (0, _esqlAst.parse)(`${command} ${allPatterns.join(', ')}`);
  return (0, _create_pipeline.createPipeline)({
    root,
    commands: [],
    params: []
  });
}
function timeseries(...patterns) {
  return buildPipeline('TS', ...patterns);
}
function from(...patterns) {
  return buildPipeline('FROM', ...patterns);
}