"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isESQLNamedParamLiteral = exports.isESQLFunction = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @deprecated A full query AST is represented by {@link ESQLAstQueryExpression} type.
 */

/**
 * Represents an *expression* in the AST.
 */

/**
 * A field is either an index field `this.is.field`, or it is a field assignment
 * `new_field = 123`, in which case it is a binary expression with "=" operator.
 *
 * Also, a field can be specified as a parameter.
 *
 * ```
 * EVAL this.is.a.nested.field
 * EVAL new_field = 123
 * EVAL ?param
 * EVAL ?param = 123
 * ```
 */

/**
 * An array of AST nodes represents different things in different contexts.
 * For example, in command top level arguments it is treated as an "assignment expression".
 */

/**
 * *Proper* are nodes which are objects with `type` property, once we get rid
 * of the nodes which are plain arrays, all nodes will be *proper* and we can
 * remove this type.
 */

/**
 * Contains optional formatting information used by the pretty printer.
 */

/**
 * Represents a header pseudo-command, such as SET.
 *
 * Example:
 *
 * ```
 * SET setting1 = "value1", setting2 = "value2";
 * ```
 */

/**
 * We coalesce all function calls and expressions into a single "function"
 * node type. This subtype is used to distinguish between different types
 * of function calls and expressions.
 *
 * - `variadic-call` is a function call with any number of arguments: fn(a, b, c, ...)
 * - `unary-expression` is a unary expression: -a, +a, NOT a, ...
 * - `binary-expression` is a binary expression: a + b, a - b, a * b, ...
 */

// a + b, a - b, a * b, ...

const isESQLAstBaseItem = node => typeof node === 'object' && node !== null && Object.hasOwn(node, 'name') && Object.hasOwn(node, 'text');
const isESQLFunction = node => isESQLAstBaseItem(node) && Object.hasOwn(node, 'type') && node.type === 'function';

/**
 * Represents an order expression used in SORT commands.
 *
 * ```
 * ... | SORT field ASC NULLS FIRST
 * ```
 */

// from https://github.com/elastic/elasticsearch/blob/122e7288200ee03e9087c98dff6cebbc94e774aa/docs/reference/esql/functions/kibana/inline_cast.json

/**
 * This node represents something the AST generator
 * didn't recognize in the ANTLR parse tree.
 *
 * It can show up if the AST generator code is out of sync
 * with the ANTLR grammar or if there is some idiosyncrasy
 * or bug in the parse tree.
 *
 * These nodes can be ignored for the purpose of validation
 * and autocomplete, but they may be helpful in detecting bugs.
 */

/**
 * Represents any expression wrapped in parentheses.
 *
 * ```
 * FROM ( <query> )
 * ```
 */

/**
 * Represents list-like structures where elements are separated by commas.
 *
 * *Literal lists* use square brackets and can contain only
 * string, number, or boolean literals and all elements must be of the same
 * type:
 *
 * ```
 * [1, 2, 3]
 * ```
 *
 * *Tuple lists* use round brackets and can contain any type of expression.
 * Tuple list are used in the `IN` expression:
 *
 * ```
 * a IN ("abc", "def")
 * ```
 */

/**
 * Represents a ES|QL "map" object, normally used as the last argument of a
 * function.
 */

/**
 * Represents a key-value pair in a ES|QL map object.
 */

// Exporting here to prevent TypeScript error TS4058
// Return type of exported function has or is using name 'ESQLNumericLiteral' from external module
// @internal

// We cast anything as decimal (e.g. 32.12) as generic decimal numeric type here
// @internal

// @internal

// @internal

// @internal

// @internal

// @internal

/**
 * *Unnamed* parameter is not named, just a question mark "?".
 *
 * @internal
 */

/**
 * *Named* parameter is a question mark followed by a name "?name".
 *
 * @internal
 */

/**
 * *Positional* parameter is a question mark followed by a number "?1".
 *
 * @internal
 */
exports.isESQLFunction = isESQLFunction;
const isESQLNamedParamLiteral = node => isESQLAstBaseItem(node) && node.literalType === 'param' && node.paramType === 'named';
exports.isESQLNamedParamLiteral = isESQLNamedParamLiteral;