"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureKeywordAndText = ensureKeywordAndText;
exports.getFunctionsToIgnoreForStats = getFunctionsToIgnoreForStats;
exports.isAggFunctionUsedAlready = isAggFunctionUsedAlready;
exports.isTimeseriesAggUsedAlready = isTimeseriesAggUsedAlready;
var _is = require("../../../ast/is");
var _types = require("../../types");
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function checkContentPerDefinition(fn, def) {
  const fnDef = (0, _functions.getFunctionDefinition)(fn.name);
  return !!fnDef && fnDef.type === def || extractFunctionArgs(fn.args).some(arg => checkContentPerDefinition(arg, def));
}
function isAggFunctionUsedAlready(command, argIndex) {
  if (argIndex < 0) {
    return false;
  }
  const arg = command.args[argIndex];
  return (0, _is.isFunctionExpression)(arg) ? checkContentPerDefinition(arg, _types.FunctionDefinitionTypes.AGG) : false;
}
function isTimeseriesAggUsedAlready(command, argIndex) {
  if (argIndex < 0) {
    return false;
  }
  const arg = command.args[argIndex];
  return (0, _is.isFunctionExpression)(arg) ? checkContentPerDefinition(arg, _types.FunctionDefinitionTypes.TIME_SERIES_AGG) : false;
}
function extractFunctionArgs(args) {
  return args.flatMap(arg => (0, _is.isAssignment)(arg) ? arg.args[1] : arg).filter(_is.isFunctionExpression);
}
function getFnContent(fn) {
  return [fn.name].concat(extractFunctionArgs(fn.args).flatMap(getFnContent));
}
function getFunctionsToIgnoreForStats(command, argIndex) {
  if (argIndex < 0) {
    return [];
  }
  const arg = command.args[argIndex];
  return (0, _is.isFunctionExpression)(arg) ? getFnContent(arg) : [];
}
function ensureKeywordAndText(types) {
  const result = [...types];
  if (result.includes('keyword') && !result.includes('text')) {
    result.push('text');
  }
  if (result.includes('text') && !result.includes('keyword')) {
    result.push('keyword');
  }
  return result;
}