"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SendEnterpriseSearchTelemetry = void 0;
var _react = require("react");
var _kea = require("kea");
var _telemetry_logic = require("./telemetry_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * React component helpers - useful for on-page-load/views
 */

const SendEnterpriseSearchTelemetry = ({
  action,
  metric
}) => {
  const {
    sendTelemetry
  } = (0, _kea.useActions)(_telemetry_logic.TelemetryLogic);
  (0, _react.useEffect)(() => {
    sendTelemetry({
      action,
      metric,
      product: 'enterprise_search'
    });
  }, [action, metric]);
  return null;
};
exports.SendEnterpriseSearchTelemetry = SendEnterpriseSearchTelemetry;