"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurlRequest = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cloud_details = require("../../../../../shared/cloud_details/cloud_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/components/curl_request/curl_request.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CurlRequest = ({
  indexName,
  apiKey,
  document,
  pipeline
}) => {
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const DEFAULT_URL = 'https://localhost:9200';
  const baseUrl = cloudContext.elasticsearchUrl || DEFAULT_URL;
  const apiKeyExample = apiKey || '<Replace_with_created_API_key>';
  const {
    name: pipelineName,
    ...pipelineParams
  } = pipeline !== null && pipeline !== void 0 ? pipeline : {};
  // We have to prefix the parameters with an underscore because that's what the actual pipeline looks for
  const pipelineArgs = Object.entries(pipelineParams).reduce((acc, curr) => ({
    ...acc,
    [`_${curr[0]}`]: curr[1]
  }), {});
  const inputDocument = pipeline ? {
    ...document,
    ...pipelineArgs
  } : document;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    fontSize: "m",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, `\
curl -X POST '${baseUrl}/${indexName}/_doc${pipeline ? `?pipeline=${pipelineName}` : ''}' \\
  -H 'Content-Type: application/json' \\
  -H 'Authorization: ApiKey ${apiKeyExample}' \\
  -d '${JSON.stringify(inputDocument, null, 2)}'
`);
};
exports.CurlRequest = CurlRequest;