"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _delete_search_application_modal = require("../search_applications/delete_search_application_modal");
var _search_application_connect = require("./connect/search_application_connect");
var _docs_explorer = require("./docs_explorer/docs_explorer");
var _search_application_content = require("./search_application_content");
var _search_application_view_logic = require("./search_application_view_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/search_application_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchApplicationView = () => {
  const {
    fetchSearchApplication,
    closeDeleteSearchApplicationModal
  } = (0, _kea.useActions)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    searchApplicationName,
    isDeleteModalVisible
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  (0, _react.useEffect)(() => {
    fetchSearchApplication({
      name: searchApplicationName
    });
  }, [searchApplicationName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_delete_search_application_modal.DeleteSearchApplicationModal, {
    searchApplicationName: searchApplicationName,
    onClose: closeDeleteSearchApplicationModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.DOCS_EXPLORER}`,
    component: _docs_explorer.SearchApplicationDocsExplorer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONTENT_PATH,
    component: _search_application_content.SearchApplicationContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONTENT}`,
    to: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONTENT}/${_routes.SearchApplicationContentTabs.INDICES}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_APPLICATION_CONNECT_PATH,
    component: _search_application_connect.SearchApplicationConnect,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONNECT}`,
    to: `${_routes.SEARCH_APPLICATION_PATH}/${_routes.SearchApplicationViewTabs.CONNECT}/${_routes.SearchApplicationConnectTabs.SEARCHAPI}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })));
};
exports.SearchApplicationView = SearchApplicationView;