"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _field_icon = require("../field_icon");
var _convert_results = require("./convert_results");
var _docs_explorer_logic = require("./docs_explorer_logic");
var _document_context = require("./document_context");
var _field_value_cell = require("./field_value_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/docs_explorer/document_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DocumentFlyout = () => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    fieldTypesByIndex
  } = (0, _kea.useValues)(_docs_explorer_logic.SearchApplicationDocsExplorerLogic);
  const {
    selectedDocument,
    setSelectedDocument
  } = (0, _document_context.useSelectedDocument)();
  if (!selectedDocument) return null;
  const id = selectedDocument._meta.rawHit.__id;
  const {
    fields,
    index
  } = (0, _convert_results.convertResultToFieldsAndIndex)(selectedDocument);
  const fieldTypes = fieldTypesByIndex[index];
  if (!fieldTypes) return null;
  const items = (0, _convert_results.addTypeToResults)(fields, fieldTypes);
  const columns = [{
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.documentFlyout.fieldLabel', {
      defaultMessage: 'Field'
    }),
    render: ({
      field: key,
      type
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_field_icon.FieldIcon, {
      type: type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, key)))),
    truncateText: false
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.documentFlyout.valueLabel', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_field_value_cell.FieldValueCell, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }))),
    truncateText: false
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setSelectedDocument(null),
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.documentFlyout.title",
    defaultMessage: "Document: {id}",
    values: {
      id
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.documentFlyout.fieldCount",
    defaultMessage: "{fieldCount} {fieldCount, plural, one {Field} other {Fields}}",
    values: {
      fieldCount: items.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: columns,
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })));
};
exports.DocumentFlyout = DocumentFlyout;