"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _persistable_state = require("./persistable_state");
var _get_all_migrations = require("./persistable_state/get_all_migrations");
var _registry = require("../common/enhancements/registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EmbeddableServerPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "embeddableFactories", new Map());
    (0, _defineProperty2.default)(this, "enhancementsRegistry", new _registry.EnhancementsRegistry());
    (0, _defineProperty2.default)(this, "migrateFn", void 0);
    (0, _defineProperty2.default)(this, "transformsRegistry", {});
    (0, _defineProperty2.default)(this, "registerEmbeddableFactory", factory => {
      if (this.embeddableFactories.has(factory.id)) {
        throw new Error(`Embeddable factory [embeddableFactoryId = ${factory.id}] already registered in Embeddables API.`);
      }
      this.embeddableFactories.set(factory.id, {
        id: factory.id,
        telemetry: factory.telemetry || ((state, stats) => stats),
        inject: factory.inject || _lodash.identity,
        extract: factory.extract || (state => ({
          state,
          references: []
        })),
        migrations: factory.migrations || {}
      });
    });
    (0, _defineProperty2.default)(this, "getEmbeddableFactory", embeddableFactoryId => {
      return this.embeddableFactories.get(embeddableFactoryId) || {
        telemetry: (state, stats) => stats,
        inject: state => state,
        extract: state => {
          return {
            state,
            references: []
          };
        },
        migrations: {}
      };
    });
  }
  setup(core) {
    this.migrateFn = (0, _persistable_state.getMigrateFunction)(this.getEmbeddableFactory, this.enhancementsRegistry.getEnhancement);
    return {
      registerEmbeddableFactory: this.registerEmbeddableFactory,
      registerTransforms: (type, transforms) => {
        if (this.transformsRegistry[type]) {
          throw new Error(`Embeddable transforms for type "${type}" are already registered.`);
        }
        this.transformsRegistry[type] = transforms;
      },
      registerEnhancement: this.enhancementsRegistry.registerEnhancement,
      transformEnhancementsIn: this.enhancementsRegistry.transformIn,
      transformEnhancementsOut: this.enhancementsRegistry.transformOut,
      telemetry: (0, _persistable_state.getTelemetryFunction)(this.getEmbeddableFactory, this.enhancementsRegistry.getEnhancement),
      extract: (0, _persistable_state.getExtractFunction)(this.getEmbeddableFactory, this.enhancementsRegistry.getEnhancement),
      inject: (0, _persistable_state.getInjectFunction)(this.getEmbeddableFactory, this.enhancementsRegistry.getEnhancement),
      getAllMigrations: () => (0, _get_all_migrations.getAllMigrations)(Array.from(this.embeddableFactories.values()), this.enhancementsRegistry.getEnhancements(), this.migrateFn)
    };
  }
  start(core) {
    return {
      getEmbeddableSchemas: () => Object.values(this.transformsRegistry).map(transforms => transforms.schema).filter(schema => Boolean(schema)),
      getTransforms: type => {
        return this.transformsRegistry[type];
      },
      telemetry: (0, _persistable_state.getTelemetryFunction)(this.getEmbeddableFactory, this.enhancementsRegistry.getEnhancement),
      extract: (0, _persistable_state.getExtractFunction)(this.getEmbeddableFactory, this.enhancementsRegistry.getEnhancement),
      inject: (0, _persistable_state.getInjectFunction)(this.getEmbeddableFactory, this.enhancementsRegistry.getEnhancement),
      getAllMigrations: () => (0, _get_all_migrations.getAllMigrations)(Array.from(this.embeddableFactories.values()), this.enhancementsRegistry.getEnhancements(), this.migrateFn)
    };
  }
  stop() {}
}
exports.EmbeddableServerPlugin = EmbeddableServerPlugin;