"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRecommendedFields = void 0;
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createRecommendedFields = ({
  defaultFields
}) => {
  return prev => () => ({
    ...(prev ? prev() : {}),
    recommendedFields: [...(defaultFields !== null && defaultFields !== void 0 ? defaultFields : _discoverUtils.DEFAULT_LOGS_PROFILE.recommendedFields)]
  });
};
exports.createRecommendedFields = createRecommendedFields;