"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailureStoreHoverLink = void 0;
var _eui = require("@elastic/eui");
var _failureStoreModal = require("@kbn/failure-store-modal");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/table/failure_store_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FailureStoreHoverLink = ({
  dataStreamStat
}) => {
  var _dataStreamStat$hasFa;
  const [hovered, setHovered] = _react.default.useState(false);
  const [isFailureStoreModalOpen, setIsFailureStoreModalOpen] = (0, _react.useState)(false);
  const {
    updateFailureStore
  } = (0, _hooks.useDatasetQualityTable)();
  const closeModal = () => {
    setIsFailureStoreModalOpen(false);
  };
  const handleSaveModal = async data => {
    updateFailureStore({
      dataStreamName: dataStreamStat.rawName,
      failureStoreEnabled: data.failureStoreEnabled,
      customRetentionPeriod: data.customRetentionPeriod
    });
    closeModal();
  };
  const onClick = () => {
    setIsFailureStoreModalOpen(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.datasetQuality.failureStore.notEnabled', {
      defaultMessage: 'Failure store is not enabled for this data stream. Enable failure store.'
    }),
    "data-test-subj": "failureStoreNotEnabledTooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `datasetQualitySetFailureStoreLink-${dataStreamStat.rawName}`,
    onMouseEnter: () => setHovered(true),
    onMouseLeave: () => setHovered(false),
    css: {
      fontWeight: 'normal'
    },
    "aria-label": _i18n.i18n.translate('xpack.datasetQuality.failureStore.setAriaLabel', {
      defaultMessage: 'Set failure store for data stream {dataStreamName}',
      values: {
        dataStreamName: dataStreamStat.rawName
      }
    }),
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, hovered ? _i18n.i18n.translate('xpack.datasetQuality.failureStore.enable', {
    defaultMessage: 'Set failure store'
  }) : _i18n.i18n.translate('xpack.datasetQuality.failureStore.notAvailable', {
    defaultMessage: 'N/A'
  }))), isFailureStoreModalOpen && /*#__PURE__*/_react.default.createElement(_failureStoreModal.FailureStoreModal, {
    onCloseModal: closeModal,
    onSaveModal: handleSaveModal,
    failureStoreProps: {
      failureStoreEnabled: (_dataStreamStat$hasFa = dataStreamStat.hasFailureStore) !== null && _dataStreamStat$hasFa !== void 0 ? _dataStreamStat$hasFa : false,
      defaultRetentionPeriod: dataStreamStat.defaultRetentionPeriod,
      customRetentionPeriod: dataStreamStat.customRetentionPeriod
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }));
};
exports.FailureStoreHoverLink = FailureStoreHoverLink;