"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopValues = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _react2 = require("@emotion/react");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _kibana_context = require("../../../kibana_context");
var _utils = require("../utils");
var _expanded_row_field_header = require("../stats_table/components/expanded_row_field_header");
var _expanded_row_panel = require("../stats_table/components/field_data_expanded_row/expanded_row_panel");
var _examples_list = require("../examples_list/examples_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/top_values/top_values.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getPercentLabel(percent) {
  if (percent >= 0.1) {
    return `${(0, _mlNumberUtils.roundToDecimalPlace)(percent, 1)}%`;
  } else if (percent === 0) {
    return '0%';
  } else {
    return '< 0.1%';
  }
}
const TopValues = ({
  stats,
  fieldFormat,
  barColor,
  compressed,
  onAddFilter,
  /** Top values by default show % of time a value exist in sampled records/rows (i.e. value A exists in 10% of sampled records)
   * showSampledValues: true shows % of times a value exist in all arrays of values that have been flattened
   * Example for 4 records: ["a", "a", "b"], ["b", "b", "c"], "d", "e"
   * "a" exists in 1/4 records (50% - showSampledValues: false),
   * "a" exists in 2/8 sampled values (25% - showSampledValues: true).
   */
  showSampledValues = false
}) => {
  var _ref, _stats$topValuesSampl, _stats$totalDocuments;
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const fieldDataTopValuesContainer = (0, _react2.css)({
    paddingTop: euiTheme.size.xs
  });
  const topValuesValueLabelContainer = (0, _react2.css)({
    marginRight: euiTheme.size.m
  });
  const topValueLabelStyles = (0, _react2.css)({
    textOverflow: 'ellipsis'
  });
  const topValueBarStyles = (0, _react2.css)({
    maxInlineSize: 'calc(100% - 52px)'
  });
  if (stats === undefined || !stats.topValues) return null;
  const {
    fieldName,
    sampleCount,
    approximate
  } = stats;
  const originalTopValues = (_ref = showSampledValues ? stats.sampledValues : stats.topValues) !== null && _ref !== void 0 ? _ref : [];
  if ((originalTopValues === null || originalTopValues === void 0 ? void 0 : originalTopValues.length) === 0) return null;
  const totalDocuments = showSampledValues ? (_stats$topValuesSampl = stats.topValuesSampleSize) !== null && _stats$topValuesSampl !== void 0 ? _stats$topValuesSampl : 0 : Math.min(sampleCount !== null && sampleCount !== void 0 ? sampleCount : Infinity, (_stats$totalDocuments = stats.totalDocuments) !== null && _stats$totalDocuments !== void 0 ? _stats$totalDocuments : Infinity);
  const getMessage = () => {
    if (showSampledValues && stats.topValuesSampleSize !== undefined) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.dataGrid.field.topValues.calculatedFromSampleValuesLabel",
        defaultMessage: "Calculated from {sampledDocumentsFormatted} sample {sampledDocuments, plural, one {value} other {values}}.",
        values: {
          sampledDocuments: stats.topValuesSampleSize,
          sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 102,
              columnNumber: 15
            }
          }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(stats.topValuesSampleSize))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 9
        }
      });
    }
    /**
     * For ES|QL, where are randomly sampling a subset from source data, then query is excuted on top of that data
     * So the terms we get might not get the initial count
     */
    const method = approximate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.topValues.estimatedMsg",
      defaultMessage: "Estimated",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.topValues.calculatedMsg",
      defaultMessage: "Calculated",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    });
    return totalDocuments > (sampleCount !== null && sampleCount !== void 0 ? sampleCount : 0) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.topValues.calculatedFromSampleRecordsLabel",
      defaultMessage: "{method} from {sampledDocumentsFormatted} sample {sampledDocuments, plural, one {record} other {records}}.",
      values: {
        method,
        sampledDocuments: sampleCount,
        sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 13
          }
        }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(sampleCount))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.topValues.calculatedFromTotalRecordsLabel",
      defaultMessage: "{method} from {totalDocumentsFormatted} {totalDocuments, plural, one {record} other {records}}.",
      values: {
        method,
        totalDocuments,
        totalDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 152,
            columnNumber: 13
          }
        }, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(totalDocuments !== null && totalDocuments !== void 0 ? totalDocuments : 0))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    });
  };
  const countsElement = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, getMessage());
  const topValues = originalTopValues.map(bucket => ({
    ...bucket,
    percent: typeof bucket.percent === 'number' ? bucket.percent : bucket.doc_count / totalDocuments
  }));
  const shouldShowOtherCount = approximate !== true;
  const topValuesOtherCountPercent = 1 - (topValues ? topValues.reduce((acc, bucket) => acc + bucket.percent, 0) : 0);
  const topValuesOtherCount = Math.floor(topValuesOtherCountPercent * (sampleCount !== null && sampleCount !== void 0 ? sampleCount : 0));
  return /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    grow: true,
    dataTestSubj: 'dataVisualizerFieldDataTopValues',
    className: (0, _classnames.default)('dvPanel__wrapper', compressed ? 'dvPanel--compressed' : undefined),
    css: (0, _react2.css)`
        overflow-x: auto;
        ${(0, _eui.euiScrollBarStyles)(euiThemeContext)};
        max-width: 420px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, showSampledValues ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.topSampledValuesLabel",
    defaultMessage: "Top sampled values",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.topValuesLabel",
    defaultMessage: "Top values",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dataVisualizerFieldDataTopValuesContent",
    className: "dvTopValues__wrapper",
    css: fieldDataTopValuesContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }, Array.isArray(topValues) ? topValues.map(value => {
    var _value$key_as_string;
    const fieldValue = (_value$key_as_string = value.key_as_string) !== null && _value$key_as_string !== void 0 ? _value$key_as_string : value.key ? value.key.toString() : '';
    const displayValue = fieldValue === '' ? _examples_list.EMPTY_EXAMPLE : fieldValue;
    const label = value.key ? (0, _utils.kibanaFieldFormat)(value.key, fieldFormat) : displayValue;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      key: displayValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: topValueBarStyles,
      "data-test-subj": "dataVisualizerFieldDataTopValueBar",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      value: value.percent,
      max: 1,
      color: barColor,
      size: "xs",
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        css: topValueLabelStyles,
        text: label,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 30
        }
      }),
      css: topValuesValueLabelContainer,
      valueText: `${value.doc_count}${totalDocuments !== undefined ? ` (${getPercentLabel(value.percent * 100)})` : ''}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 21
      }
    })), fieldName !== undefined && displayValue !== undefined && onAddFilter !== undefined ? /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
                        position: static;
                        width: 48px;
                      `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconSize: "s",
      iconType: "plusInCircle",
      onClick: () => onAddFilter(fieldName, fieldValue, '+'),
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.addFilterAriaLabel', {
        defaultMessage: 'Filter for {fieldName}: "{value}"',
        values: {
          fieldName,
          value: displayValue
        }
      }),
      "data-test-subj": `dvFieldDataTopValuesAddFilterButton-${fieldName}-${displayValue}`,
      style: {
        minHeight: 'auto',
        minWidth: 'auto',
        paddingRight: 2,
        paddingLeft: 2,
        paddingTop: 0,
        paddingBottom: 0
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconSize: "s",
      iconType: "minusInCircle",
      onClick: () => onAddFilter(fieldName, fieldValue, '-'),
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.removeFilterAriaLabel', {
        defaultMessage: 'Filter out {fieldName}: "{value}"',
        values: {
          fieldName,
          value: displayValue
        }
      }),
      "data-test-subj": `dvFieldDataTopValuesExcludeFilterButton-${fieldName}-${displayValue}`,
      style: {
        minHeight: 'auto',
        minWidth: 'auto',
        paddingTop: 0,
        paddingBottom: 0,
        paddingRight: 2,
        paddingLeft: 2
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 23
      }
    })) : null);
  }) : null, shouldShowOtherCount && topValuesOtherCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    key: "other",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: topValueBarStyles,
    "data-test-subj": "dataVisualizerFieldDataTopValueBar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: topValuesOtherCount,
    max: totalDocuments,
    color: barColor,
    size: "xs",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.topValuesOtherLabel",
      defaultMessage: "Other",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 19
      }
    }),
    className: "eui-textTruncate",
    css: topValuesValueLabelContainer,
    valueText: `${topValuesOtherCount}${totalDocuments !== undefined ? ` (${getPercentLabel(topValuesOtherCountPercent * 100)})` : ''}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 15
    }
  })), onAddFilter ? /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                  width: 48px;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 15
    }
  }) : null) : null, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  }), countsElement)));
};
exports.TopValues = TopValues;