"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/editors/color/color_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ColorRow = ({
  color,
  index,
  fieldType,
  showDeleteButton,
  onColorChange,
  onRemoveColor
}) => {
  const {
    range,
    regex,
    boolean,
    text,
    background
  } = color;
  const getInputByFieldType = () => {
    if (fieldType === 'boolean') {
      const booleanLabel = _i18n.i18n.translate('indexPatternFieldEditor.color.booleanLabel', {
        defaultMessage: 'Boolean'
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        prepend: booleanLabel,
        "aria-label": booleanLabel,
        options: [{
          value: 'true',
          text: 'true'
        }, {
          value: 'false',
          text: 'false'
        }],
        value: boolean,
        "data-test-subj": `colorEditorKeyBoolean ${index}`,
        onChange: e => {
          onColorChange({
            boolean: e.target.value
          }, index);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 9
        }
      });
    }
    if (fieldType === 'string') {
      const patternLabel = _i18n.i18n.translate('indexPatternFieldEditor.color.patternLabel', {
        defaultMessage: 'Pattern'
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        prepend: patternLabel,
        "aria-label": patternLabel,
        value: regex,
        "data-test-subj": `colorEditorKeyPattern ${index}`,
        onChange: e => {
          onColorChange({
            regex: e.target.value
          }, index);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 9
        }
      });
    }
    const rangeLabel = _i18n.i18n.translate('indexPatternFieldEditor.color.rangeLabel', {
      defaultMessage: 'Range'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      prepend: rangeLabel,
      "aria-label": rangeLabel,
      value: range,
      "data-test-subj": `colorEditorKeyRange ${index}`,
      onChange: e => {
        onColorChange({
          range: e.target.value
        }, index);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, getInputByFieldType()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    color: text,
    "data-test-subj": `colorEditorColorPicker ${index}`,
    onChange: newColor => {
      onColorChange({
        text: newColor
      }, index);
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: "false",
      iconType: "lettering",
      color: "text",
      onClick: () => {},
      "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.color.letteringButtonAriaLabel', {
        defaultMessage: 'Select a text color for item {index}',
        values: {
          index
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": text,
      color: text,
      size: "l",
      type: "stopFilled",
      "data-test-subj": "buttonColorSwatchIcon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 15
      }
    })),
    secondaryInputDisplay: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    color: background,
    "data-test-subj": `colorEditorBackgroundPicker ${index}`,
    onChange: newColor => {
      onColorChange({
        background: newColor
      }, index);
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: "false",
      iconType: "color",
      color: "text",
      onClick: () => {},
      "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.color.letteringButtonAriaLabel', {
        defaultMessage: 'Select a background color for item {index}',
        values: {
          index
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": background,
      color: background,
      size: "l",
      type: "stopFilled",
      "data-test-subj": "buttonColorSwatchIcon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 15
      }
    })),
    secondaryInputDisplay: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  })), showDeleteButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    onClick: () => {
      onRemoveColor(index);
    },
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.color.deleteTitle', {
      defaultMessage: 'Delete color format'
    }),
    "data-test-subj": "colorEditorRemoveColor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  })));
};
exports.ColorRow = ColorRow;