"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformDashboardOut = transformDashboardOut;
var _common = require("@kbn/saved-objects-tagging-plugin/common");
var _transform_control_group_out = require("./transform_control_group_out");
var _transform_search_source_out = require("./transform_search_source_out");
var _transform_options_out = require("./transform_options_out");
var _transform_panels_out = require("./transform_panels_out");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformDashboardOut(attributes, references) {
  const {
    controlGroupInput,
    description,
    kibanaSavedObjectMeta,
    optionsJSON,
    panelsJSON,
    sections,
    refreshInterval,
    timeFrom,
    timeRestore,
    timeTo,
    title
  } = attributes;

  // Extract tag references
  const tags = references ? references.filter(({
    type
  }) => type === _common.tagSavedObjectTypeName).map(({
    id
  }) => id) : [];
  const timeRange = timeRestore && timeFrom && timeTo ? {
    from: timeFrom,
    to: timeTo
  } : undefined;
  const options = (0, _transform_options_out.transformOptionsOut)(optionsJSON !== null && optionsJSON !== void 0 ? optionsJSON : '{}');

  // try to maintain a consistent (alphabetical) order of keys
  return {
    ...(controlGroupInput && {
      controlGroupInput: (0, _transform_control_group_out.transformControlGroupOut)(controlGroupInput)
    }),
    ...(description && {
      description
    }),
    ...(0, _transform_search_source_out.transformSearchSourceOut)(kibanaSavedObjectMeta, references),
    ...(Object.keys(options).length && {
      options
    }),
    ...((panelsJSON || sections) && {
      panels: (0, _transform_panels_out.transformPanelsOut)(panelsJSON, sections, references)
    }),
    ...(refreshInterval && {
      refreshInterval: {
        pause: refreshInterval.pause,
        value: refreshInterval.value
      }
    }),
    ...(tags && tags.length && {
      tags
    }),
    ...(timeRange && {
      timeRange
    }),
    title: title !== null && title !== void 0 ? title : ''
  };
}