"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardCRUResponseBody = getDashboardCRUResponseBody;
exports.getDashboardMeta = getDashboardMeta;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardMeta(savedObject, operation) {
  var _savedObject$version;
  return {
    error: savedObject.error,
    managed: savedObject.managed,
    updatedAt: savedObject.updated_at,
    updatedBy: savedObject.updated_by,
    version: (_savedObject$version = savedObject.version) !== null && _savedObject$version !== void 0 ? _savedObject$version : '',
    ...(['create', 'read', 'search'].includes(operation) && {
      createdAt: savedObject.created_at,
      createdBy: savedObject.created_by
    })
  };
}

// CRU is Create, Read, Update
function getDashboardCRUResponseBody(savedObject, operation) {
  let dashboardState;
  let references;
  try {
    var _savedObject$referenc;
    dashboardState = (0, _transforms.transformDashboardOut)(savedObject.attributes, savedObject.references);
    references = (0, _transforms.transformReferencesOut)((_savedObject$referenc = savedObject.references) !== null && _savedObject$referenc !== void 0 ? _savedObject$referenc : [], dashboardState.panels);
  } catch (transformOutError) {
    throw _boom.default.badRequest(`Invalid response. ${transformOutError.message}`);
  }
  return {
    id: savedObject.id,
    data: {
      ...dashboardState,
      ...(references.length && {
        references
      })
    },
    meta: getDashboardMeta(savedObject, operation),
    spaces: savedObject.namespaces
  };
}