"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSearchSessionManager = initializeSearchSessionManager;
var _rxjs = require("rxjs");
var _kibana_services = require("../../services/kibana_services");
var _start_dashboard_search_session_integration = require("./start_dashboard_search_session_integration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeSearchSessionManager(searchSessionSettings, incomingEmbeddables, dashboardApi, dashboardInternalApi) {
  const searchSessionId$ = new _rxjs.BehaviorSubject(undefined);
  let stopSearchSessionIntegration;
  let requestSearchSessionId;
  if (searchSessionSettings) {
    const {
      sessionIdToRestore
    } = searchSessionSettings;

    // if this incoming embeddable has a session, continue it.
    incomingEmbeddables === null || incomingEmbeddables === void 0 ? void 0 : incomingEmbeddables.forEach(embeddablePackage => {
      if (embeddablePackage.searchSessionId) {
        _kibana_services.dataService.search.session.continue(embeddablePackage.searchSessionId);
      }
    });
    if (sessionIdToRestore) {
      _kibana_services.dataService.search.session.restore(sessionIdToRestore);
    }
    const existingSession = _kibana_services.dataService.search.session.getSessionId();
    const initialSearchSessionId = sessionIdToRestore !== null && sessionIdToRestore !== void 0 ? sessionIdToRestore : existingSession && incomingEmbeddables !== null && incomingEmbeddables !== void 0 && incomingEmbeddables.length ? existingSession : _kibana_services.dataService.search.session.start();
    searchSessionId$.next(initialSearchSessionId);

    // `requestSearchSessionId` should be used when you need to ensure that you have the up-to-date search session ID
    const searchSessionGenerationInProgress$ = new _rxjs.BehaviorSubject(false);
    requestSearchSessionId = async () => {
      if (!searchSessionGenerationInProgress$.getValue()) return searchSessionId$.getValue();
      return new Promise(resolve => {
        const subscription = searchSessionGenerationInProgress$.subscribe(inProgress => {
          if (!inProgress) {
            resolve(searchSessionId$.getValue());
            subscription.unsubscribe();
          }
        });
      });
    };
    stopSearchSessionIntegration = (0, _start_dashboard_search_session_integration.startDashboardSearchSessionIntegration)({
      ...dashboardApi,
      searchSessionId$
    }, dashboardInternalApi, searchSessionSettings, searchSessionId => searchSessionId$.next(searchSessionId), searchSessionGenerationInProgress$);
  }
  return {
    api: {
      searchSessionId$,
      requestSearchSessionId
    },
    cleanup: () => {
      var _stopSearchSessionInt;
      (_stopSearchSessionInt = stopSearchSessionIntegration) === null || _stopSearchSessionInt === void 0 ? void 0 : _stopSearchSessionInt();
    }
  };
}