"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexPauseProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _actions = require("../../store/actions");
var _utils = require("../../../../common/services/utils");
var _follower_index_default_settings = require("../../services/follower_index_default_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/follower_index_actions_providers/follower_index_pause_provider.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FollowerIndexPauseProviderUi extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalOpen: false,
      indices: []
    });
    (0, _defineProperty2.default)(this, "onMouseOverModal", event => {
      // This component can sometimes be used inside of an EuiToolTip, in which case mousing over
      // the modal can trigger the tooltip. Stopping propagation prevents this.
      event.stopPropagation();
    });
    (0, _defineProperty2.default)(this, "pauseFollowerIndex", index => {
      this.setState({
        isModalOpen: true,
        indices: (0, _utils.arrify)(index)
      });
    });
    (0, _defineProperty2.default)(this, "onConfirm", () => {
      this.props.pauseFollowerIndex(this.state.indices.map(index => index.name));
      this.setState({
        isModalOpen: false,
        indices: []
      });
      this.props.onConfirm && this.props.onConfirm();
    });
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        isModalOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderModal", () => {
      const {
        indices
      } = this.state;
      const isSingle = indices.length === 1;
      const title = isSingle ? _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.pauseSingleTitle', {
        defaultMessage: `Pause replication to follower index ''{name}''?`,
        values: {
          name: indices[0].name
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.pauseMultipleTitle', {
        defaultMessage: 'Pause replication to {count} follower indices?',
        values: {
          count: indices.length
        }
      });
      const hasCustomSettings = indices.some(index => !(0, _follower_index_default_settings.areAllSettingsDefault)(index));
      const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
        _react.default.createElement(_eui.EuiConfirmModal, {
          "aria-labelledby": confirmModalTitleId,
          title: title,
          titleProps: {
            id: confirmModalTitleId
          },
          onCancel: this.closeConfirmModal,
          onConfirm: this.onConfirm,
          cancelButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.cancelButtonText', {
            defaultMessage: 'Cancel'
          }),
          buttonColor: hasCustomSettings ? 'danger' : 'primary',
          confirmButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.confirmButtonText', {
            defaultMessage: 'Pause replication'
          }),
          onMouseOver: this.onMouseOverModal,
          "data-test-subj": "pauseReplicationConfirmation",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 7
          }
        }, hasCustomSettings && /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 11
          }
        }, isSingle ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.singlePauseDescriptionWithSettingWarning",
          defaultMessage: "Pausing replication to this follower index clears its custom advanced settings.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 15
          }
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.multiplePauseDescriptionWithSettingWarning",
          defaultMessage: "Pausing replication to a follower index clears its custom advanced settings.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 15
          }
        })), !isSingle && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.pauseFollowerIndex.confirmModal.multiplePauseDescription",
          defaultMessage: "Replication will pause on these follower indices:",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement("ul", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 13
          }
        }, indices.map(index => /*#__PURE__*/_react.default.createElement("li", {
          key: index.name,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 125,
            columnNumber: 17
          }
        }, index.name)))))
      );
    });
  }
  render() {
    const {
      children
    } = this.props;
    const {
      isModalOpen
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }, children(this.pauseFollowerIndex), isModalOpen && this.renderModal());
  }
}
(0, _defineProperty2.default)(FollowerIndexPauseProviderUi, "propTypes", {
  onConfirm: _propTypes.default.func
});
const mapDispatchToProps = dispatch => ({
  pauseFollowerIndex: id => dispatch((0, _actions.pauseFollowerIndex)(id))
});
const FollowerIndexPauseProvider = exports.FollowerIndexPauseProvider = (0, _reactRedux.connect)(undefined, mapDispatchToProps)(FollowerIndexPauseProviderUi);